#include "signal_name.h"

using namespace NZoom::NProtobuf;

TSignalNameDeserializer::TSignalNameDeserializer(const NYasm::NInterfaces::NInternal::TSignalNameTable& table) {
    const auto& names = table.GetName();
    if (!names.empty()) {
        Signals = NZoom::NSignal::TSignalName::CreateMany({names.data(), static_cast<size_t>(names.size())});
    }
}

NZoom::NSignal::TSignalName TSignalNameDeserializer::Deserialize(const NYasm::NInterfaces::NInternal::TSignalName& signalName) const {
    return Signals.at(signalName.GetIndex());
}

TSignalExpressionSerializer::TSignalExpressionSerializer(NYasm::NInterfaces::NInternal::TSignalNameTable* table)
    : Table(table) {
}

void TSignalExpressionSerializer::Intern(const TString& source, NYasm::NInterfaces::NInternal::TSignalName* dest) {
    auto [it, inserted] = Signals.emplace(source, Table->NameSize());
    if (inserted) {
        *Table->MutableName()->Add() = source;
    }
    dest->SetIndex(it->second);
}

TSignalExpressionDeserializer::TSignalExpressionDeserializer(const NYasm::NInterfaces::NInternal::TSignalNameTable& table)
    : Signals(table.GetName().begin(), table.GetName().end()) {
}

TString TSignalExpressionDeserializer::Deserialize(const NYasm::NInterfaces::NInternal::TSignalName& signalName) const {
    return Signals.at(signalName.GetIndex());
}
