#pragma once

#include <infra/yasm/common/labels/signal/signal_name.h>
#include <infra/yasm/interfaces/internal/signal_name.pb.h>

#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

#include <util/generic/vector.h>

namespace NZoom::NProtobuf {
    class TSignalNameSerializer {
    public:
        TSignalNameSerializer(NYasm::NInterfaces::NInternal::TSignalNameTable* table)
            : Table{table}
        {
        }

        void Intern(NZoom::NSignal::TSignalName source, NYasm::NInterfaces::NInternal::TSignalName* dest) {
            auto* names = Table->MutableName();

            auto [it, isNew] = Signals.emplace(source, names->size());
            dest->SetIndex(it->second);

            if (isNew) {
                *names->Add() = source.GetName();
            }
        }

    private:
        NYasm::NInterfaces::NInternal::TSignalNameTable* Table;
        absl::flat_hash_map<NSignal::TSignalName, ui32, THash<NSignal::TSignalName>> Signals;
    };

    class TSignalNameDeserializer {
    public:
        TSignalNameDeserializer(const NYasm::NInterfaces::NInternal::TSignalNameTable& table);

        NZoom::NSignal::TSignalName Deserialize(const NYasm::NInterfaces::NInternal::TSignalName& signalName) const;

    private:
        TVector<NZoom::NSignal::TSignalName> Signals;
    };

    class TSignalExpressionSerializer {
    public:
        TSignalExpressionSerializer(NYasm::NInterfaces::NInternal::TSignalNameTable* table);

        void Intern(const TString& source, NYasm::NInterfaces::NInternal::TSignalName* dest);

    private:
        NYasm::NInterfaces::NInternal::TSignalNameTable* Table;
        THashMap<TString, ui32> Signals;
    };

    class TSignalExpressionDeserializer {
    public:
        TSignalExpressionDeserializer(const NYasm::NInterfaces::NInternal::TSignalNameTable& table);

        TString Deserialize(const NYasm::NInterfaces::NInternal::TSignalName& signalName) const;

    private:
        TVector<TString> Signals;
    };
}
