#include "signal_name.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/xrange.h>

using namespace NZoom::NProtobuf;
using namespace NZoom::NSignal;

Y_UNIT_TEST_SUITE(TSignalNameToProtobufTest) {
    Y_UNIT_TEST(Serialization) {
        NYasm::NInterfaces::NInternal::TSignalNameTable signalTable;
        TSignalNameSerializer signalSerializer(&signalTable);

        NYasm::NInterfaces::NInternal::TSignalName signal;
        signalSerializer.Intern(TSignalName(TStringBuf("something_summ")), &signal);

        TSignalNameDeserializer signalDeserializer(signalTable);
        UNIT_ASSERT_VALUES_EQUAL(signalDeserializer.Deserialize(signal), TSignalName(TStringBuf("something_summ")));
    }

    Y_UNIT_TEST(Missing) {
        NYasm::NInterfaces::NInternal::TSignalNameTable signalTable;
        TSignalNameSerializer signalSerializer(&signalTable);

        NYasm::NInterfaces::NInternal::TSignalName signal;
        TSignalNameDeserializer signalDeserializer(signalTable);
        UNIT_ASSERT_EXCEPTION(signalDeserializer.Deserialize(signal), std::out_of_range);
    }

    Y_UNIT_TEST(StringSerialization) {
        NYasm::NInterfaces::NInternal::TSignalNameTable signalTable;
        TSignalExpressionSerializer signalSerializer(&signalTable);

        NYasm::NInterfaces::NInternal::TSignalName signal;
        signalSerializer.Intern(TString(TStringBuf("something_summ")), &signal);

        TSignalExpressionDeserializer signalDeserializer(signalTable);
        UNIT_ASSERT_VALUES_EQUAL(signalDeserializer.Deserialize(signal), TString(TStringBuf("something_summ")));
    }

    Y_UNIT_TEST(StringMissing) {
        NYasm::NInterfaces::NInternal::TSignalNameTable signalTable;
        TSignalExpressionSerializer signalSerializer(&signalTable);

        NYasm::NInterfaces::NInternal::TSignalName signal;
        TSignalExpressionDeserializer signalDeserializer(signalTable);
        UNIT_ASSERT_EXCEPTION(signalDeserializer.Deserialize(signal), std::out_of_range);
    }
}
