#pragma once

#include <infra/yasm/interfaces/internal/subscription.pb.h>
#include <infra/yasm/zoom/components/subscription/subscription.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/host_name.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/request_key.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/signal_name.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/value_series.h>

#include <util/generic/vector.h>

namespace NZoom::NProtobuf {
    class TSubscriptionSerializer {
    public:
        TSubscriptionSerializer(THostNameSerializer& hostNameSerializer,
                                TInternedRequestKeySerializer& requestKeySerializer,
                                TSignalExpressionSerializer& signalNameSerializer);

        void Intern(const NSubscription::TSubscription& source, NYasm::NInterfaces::NInternal::TSubscription* dest);

    private:
        THostNameSerializer& HostNameSerializer;
        TInternedRequestKeySerializer& RequestKeySerializer;
        TSignalExpressionSerializer& SignalNameSerializer;
    };

    class TSubscriptionDeserializer {
    public:
        TSubscriptionDeserializer(const THostNameDeserializer& hostNameDeserializer,
                                  const TInternedRequestKeyDeserializer& requestKeyDeserializer,
                                  const TSignalExpressionDeserializer& signalNameDeserializer);

        NSubscription::TSubscription Deserialize(const NYasm::NInterfaces::NInternal::TSubscription& subscription) const;

        /* Returns subscription with a request key in a form as it was provided */
        std::pair<NSubscription::TSubscription, TString> DeserializeWithFullInfo(
            const NYasm::NInterfaces::NInternal::TSubscription& subscription) const;

    private:
        const THostNameDeserializer& HostNameDeserializer;
        const TInternedRequestKeyDeserializer& RequestKeyDeserializer;
        const TSignalExpressionDeserializer& SignalNameDeserializer;
    };

    class TSubscriptionWithValueSeriesSerializer {
    public:
        using TTargetProto = NYasm::NInterfaces::NInternal::TSubscriptionWithValueSeries;
        using TSource = NSubscription::TSubscriptionWithValueSeries;

        TSubscriptionWithValueSeriesSerializer(THostNameSerializer& hostNameSerializer,
                                               TInternedRequestKeySerializer& requestKeySerializer,
                                               TSignalExpressionSerializer& signalNameSerializer);

        void Intern(const TSource& source, TTargetProto* dest);

        template <typename TValueContainer>
        void Intern(const NSubscription::TSubscription& subscription, TInstant startTimestamp, const TValueContainer& values,
                    TTargetProto* dest) {
            SubscriptionSerializer.Intern(subscription, dest->MutableSubscription());
            dest->SetStartTimestamp(startTimestamp.Seconds());
            TValueSeriesSerializer::Serialize(values, dest->MutableValueSeries());
        }

    private:
        TSubscriptionSerializer SubscriptionSerializer;
    };

    class TSubscriptionWithValueSeriesDeserializer {
    public:
        TSubscriptionWithValueSeriesDeserializer(const THostNameDeserializer& hostNameDeserializer,
                                                 const TInternedRequestKeyDeserializer& requestKeyDeserializer,
                                                 const TSignalExpressionDeserializer& signalNameDeserializer);

        NSubscription::TSubscriptionWithValueSeries Deserialize(
            const NYasm::NInterfaces::NInternal::TSubscriptionWithValueSeries& subWithValuesProto) const;

    private:
        TSubscriptionDeserializer SubscriptionDeserializer;
    };
}
