#include "value_series.h"

namespace NZoom::NProtobuf {
    TVector<NZoom::NValue::TValue> TValueSeriesDeserializer::Deserialize(
        const NYasm::NInterfaces::NInternal::TValueSeries& valueSeriesProto) {
        TVector<NValue::TValue> result;
        DeserializeAndVisit(valueSeriesProto, [&result](auto&& value) {
            result.emplace_back(std::forward<decltype(value)>(value));
        });
        return result;
    }
}
