#pragma once

#include <infra/yasm/interfaces/internal/value_series.pb.h>
#include <infra/yasm/zoom/components/compression/chunk.h>
#include <infra/yasm/common/points/value/types.h>

#include <util/generic/vector.h>
#include <util/generic/xrange.h>

namespace NZoom::NProtobuf {
    class TValueSeriesSerializer {
    public:
        template <typename TValueContainer>
        static void Serialize(const TValueContainer& values, NYasm::NInterfaces::NInternal::TValueSeries* dest) {
            dest->SetValuesCount(values.size());
            TMaybe<NYasmServer::ESeriesKind> seriesKind;
            dest->SetValues(NYasmServer::EncodeChunk(values, seriesKind, true));
            if (seriesKind.Defined()) {
                switch (seriesKind.GetRef()) {
                    case NYasmServer::ESeriesKind::Double:
                        dest->SetValueType(NYasm::NInterfaces::NInternal::TValueSeries::DOUBLE);
                        break;
                    case NYasmServer::ESeriesKind::CountedSum:
                        dest->SetValueType(NYasm::NInterfaces::NInternal::TValueSeries::COUNTED_SUM);
                        break;
                    case NYasmServer::ESeriesKind::Histogram:
                        dest->SetValueType(NYasm::NInterfaces::NInternal::TValueSeries::HISTOGRAM);
                        break;
                }
            } else {
                dest->SetValueType(NYasm::NInterfaces::NInternal::TValueSeries::NONE);
            }
        }
    };

    class TValueSeriesDeserializer {
    public:
        static TVector<NZoom::NValue::TValue> Deserialize(const NYasm::NInterfaces::NInternal::TValueSeries& valueSeriesProto);

        template <typename TVisitor>
        static void DeserializeAndVisit(const NYasm::NInterfaces::NInternal::TValueSeries& valueSeriesProto, TVisitor visitor) {
            if (valueSeriesProto.GetValueType() != NYasm::NInterfaces::NInternal::TValueSeries::NONE) {
                NYasmServer::ESeriesKind seriesKind;
                switch (valueSeriesProto.GetValueType()) {
                    case NYasm::NInterfaces::NInternal::TValueSeries::COUNTED_SUM:
                        seriesKind = NYasmServer::ESeriesKind::CountedSum;
                        break;
                    case NYasm::NInterfaces::NInternal::TValueSeries::HISTOGRAM:
                        seriesKind = NYasmServer::ESeriesKind::Histogram;
                        break;
                    case NYasm::NInterfaces::NInternal::TValueSeries::DOUBLE:
                    default:
                        seriesKind = NYasmServer::ESeriesKind::Double;
                        break;
                }
                NYasmServer::DecodeChunkAndVisit(valueSeriesProto.GetValues(), seriesKind, valueSeriesProto.GetValuesCount(),
                    [&visitor](auto&& value) {
                    visitor(std::forward<decltype(value)>(value));
                });
            } else {
                for (size_t i: xrange(valueSeriesProto.GetValuesCount())) {
                    visitor(NZoom::NValue::TValue());
                    Y_UNUSED(i);
                }
            }
        }
    };
}
