#include "value.h"

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/xrange.h>

using namespace NZoom::NProtobuf;
using namespace NZoom::NValue;
using namespace NZoom::NHgram;

Y_UNIT_TEST_SUITE(TValueToProtobufTest) {
    Y_UNIT_TEST(SerializeAndDeserialize) {
        TVector<TValue> sourceValues;
        sourceValues.emplace_back(); // None value
        sourceValues.emplace_back(0);
        sourceValues.emplace_back(765);
        sourceValues.emplace_back(0, 0);
        sourceValues.emplace_back(0, 99);
        sourceValues.emplace_back(10, 5);
        sourceValues.emplace_back(TVector<double>({0, 1, 7, 9.6, 18.7}));
        sourceValues.emplace_back(THgram::Default());
        sourceValues.emplace_back(THgram::Small(TVector<double>(), 0));
        sourceValues.emplace_back(THgram::Small(TVector<double>(), 11));
        sourceValues.emplace_back(THgram::Small(TVector<double>({1.1, 2.2, 3.3, 14}), 0));
        sourceValues.emplace_back(THgram::Small(TVector<double>({1.1, 2.2, 3.3, 14}), 11));
        sourceValues.emplace_back(THgram::Normal(TVector<double>(), 0, -1));
        sourceValues.emplace_back(THgram::Normal(TVector<double>(), 0, -3));
        sourceValues.emplace_back(THgram::Normal(TVector<double>(), 14, 0));
        sourceValues.emplace_back(THgram::Normal(TVector<double>({1, 1.1, 0, 0, 0, 18.009, 0, 0, 66}), 14, -2));
        sourceValues.emplace_back(THgram::EmptyUgram());
        sourceValues.emplace_back(THgram::Ugram(TUgramBuckets({{0.0, 0.5, 7.7}})));
        sourceValues.emplace_back(THgram::Ugram(TUgramBuckets({{0.0, 0.5, 7.7}, {7.5, 7.5, 1}, {7.5, 33.5, 987}})));

        for (auto& sourceValue: sourceValues) {NYasm::NInterfaces::NInternal::TValue serializedValue;
            TProtobufValueSerializer<TUgramCompressor> serializer(serializedValue);
            sourceValue.Update(serializer);

            auto deserializedValue = DeserializeProtobufValue(serializedValue, true);
            UNIT_ASSERT_VALUES_EQUAL(sourceValue, deserializedValue);
            UNIT_ASSERT_VALUES_EQUAL(sourceValue.GetType(), deserializedValue.GetType());
            UNIT_ASSERT_VALUES_EQUAL(sourceValue.IsDefault(), deserializedValue.IsDefault());

            auto wrapperDeserializedIValue = DeserializeProtobufValueByWrapping(serializedValue);
            TValueCopier copier;
            wrapperDeserializedIValue.Update(copier);
            auto wrapperDeserializedValue = copier.ExtractValue();
            UNIT_ASSERT_VALUES_EQUAL(sourceValue, wrapperDeserializedValue);
            UNIT_ASSERT_VALUES_EQUAL(sourceValue.GetType(), wrapperDeserializedIValue.GetType());
            UNIT_ASSERT_VALUES_EQUAL(sourceValue.IsDefault(), wrapperDeserializedIValue.IsDefault());
            UNIT_ASSERT_VALUES_EQUAL(sourceValue.GetType(), wrapperDeserializedValue.GetType());
            UNIT_ASSERT_VALUES_EQUAL(sourceValue.IsDefault(), wrapperDeserializedValue.IsDefault());
        }
    }
}
