#include "request_key.h"

using NZoom::NSignal::TCache;

namespace NZoom::NSubscription::NPrivate {
    class TRequestKeyCacheEntry {
    public:
        explicit TRequestKeyCacheEntry(NTags::TRequestKey&& key)
            : RequestKey(std::move(key)) {
        }

        const TString& GetName() const noexcept {
            return RequestKey.ToNamed();
        }

        const TString& GetItype() const noexcept {
            return RequestKey.GetItype();
        }

        const NTags::TRequestKey& GetRequestKey() const noexcept {
            return RequestKey;
        }

    private:
        NTags::TRequestKey RequestKey;
    };

    namespace {
        const TRequestKeyCacheEntry* CreateInterned(TStringBuf raw) {
            auto cache = Singleton<TCache<TRequestKeyCacheEntry>>();
            const TRequestKeyCacheEntry* res = cache->Get(raw);
            if (res) {
                return res;
            } else {
                // try to lookup for normalized name
                auto newRequestKey = NTags::TRequestKey::NormalizedFromString(raw);
                return cache->Insert(NPrivate::TRequestKeyCacheEntry(std::move(newRequestKey)));
            }
        }
    }
}

using namespace NZoom::NSubscription;

TInternedRequestKey::TInternedRequestKey(const TString& raw)
    : Impl(NPrivate::CreateInterned(raw))
{
}

TInternedRequestKey::TInternedRequestKey(TStringBuf raw)
    : Impl(NPrivate::CreateInterned(raw))
{
}

const TString& TInternedRequestKey::GetName() const noexcept {
    return Impl->GetName();
}

const TString& TInternedRequestKey::GetItype() const noexcept {
    return Impl->GetItype();
}

const NTags::TRequestKey& TInternedRequestKey::GetRequestKey() const noexcept {
    return Impl->GetRequestKey();
}

template <>
void Out<TInternedRequestKey>(IOutputStream& stream, TTypeTraits<TInternedRequestKey>::TFuncParam key) {
    stream.Write(key.GetName());
}
