#pragma once

#include <infra/yasm/common/labels/signal/signal_name.h>
#include <infra/yasm/common/labels/tags/request_key.h>

namespace NZoom::NSubscription {
    namespace NPrivate {
        class TRequestKeyCacheEntry;
    }

    class TInternedRequestKey {
    public:
        TInternedRequestKey(const TInternedRequestKey& other) = default;
        TInternedRequestKey(const TString& raw);
        TInternedRequestKey(TStringBuf raw);

        const TString& GetName() const noexcept;
        const TString& GetItype() const noexcept;
        const NTags::TRequestKey& GetRequestKey() const noexcept;

        inline bool operator==(const TInternedRequestKey& other) const noexcept {
            return Impl == other.Impl;
        }
        inline size_t Hash() const noexcept {
            return THash<NPrivate::TRequestKeyCacheEntry*>()(Impl);
        }

    private:
        const NPrivate::TRequestKeyCacheEntry* Impl = nullptr;
    };
}

template <>
struct THash<NZoom::NSubscription::TInternedRequestKey> {
    inline size_t operator()(const NZoom::NSubscription::TInternedRequestKey& v) const noexcept {
        return v.Hash();
    }
};
