#include "request_key.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NSubscription;

Y_UNIT_TEST_SUITE(TZoomSubscriptionRequestKeyTest) {

    Y_UNIT_TEST(TestIntern) {
        TInternedRequestKey key1(TStringBuf("itype=base"));
        TInternedRequestKey key2(TString::Join("itype=", "base"));
        UNIT_ASSERT_EQUAL(key1, key2);
        UNIT_ASSERT_EQUAL(key1.Hash(), key2.Hash());
        UNIT_ASSERT_EQUAL(key1.GetName(), key2.GetName());
        UNIT_ASSERT_EQUAL(key1.GetRequestKey(), key2.GetRequestKey());
    }

    Y_UNIT_TEST(TestNormalized1) {
        TInternedRequestKey key1(TStringBuf("itype=common"));
        TInternedRequestKey key2(TStringBuf("common_self"));
        UNIT_ASSERT_EQUAL(key1, key2);
        UNIT_ASSERT_EQUAL(key1.Hash(), key2.Hash());
        UNIT_ASSERT_EQUAL(key1.GetName(), key2.GetName());
        UNIT_ASSERT_EQUAL(key1.GetRequestKey(), key2.GetRequestKey());
    }

    Y_UNIT_TEST(TestNormalized2) {
        TInternedRequestKey key1(TStringBuf("itype=common;ctype=prod;geo=sas"));
        TInternedRequestKey key2(TStringBuf("ctype=prod;geo=sas;itype=common"));
        UNIT_ASSERT_EQUAL(key1, key2);
        UNIT_ASSERT_EQUAL(key1.Hash(), key2.Hash());
        UNIT_ASSERT_EQUAL(key1.GetName(), key2.GetName());
        UNIT_ASSERT_EQUAL(key1.GetRequestKey(), key2.GetRequestKey());
    }
}
