#include "subscription.h"

namespace NZoom {
    namespace NSubscription {
        TTagSignals SubscriptionsToTagSignals(const TVector<TSubscription>& subscriptions) {
            TTagSignals result;
            for (const auto& subscription: subscriptions) {
                result[subscription.GetRequestKey()].emplace_back(subscription.GetSignalExpression());
            }
            return result;
        }

        THostTagSignals SubscriptionsToHostTagSignals(const TVector<TSubscription>& subscriptions) {
            THostTagSignals result;
            for (const auto& subscription: subscriptions) {
                result[subscription.GetHostName()][subscription.GetRequestKey()].emplace_back(subscription.GetSignalExpression());
            }
            return result;
        }

        size_t GetSubscriptionBucket(const NHost::THostName& host, const TInternedRequestKey& tags, size_t bucketCount) {
            ui64 hashValue = CombineHashes(CityHash64(host.GetName()), CityHash64(tags.GetName()));
            return ConsistentHashing(hashValue, bucketCount);
        }

        size_t GetSubscriptionBucket(const TSubscription& subscription, size_t bucketCount) {
            return GetSubscriptionBucket(subscription.GetHostName(), subscription.GetRequestKey(), bucketCount);
        }
    }
}

using namespace NZoom::NSubscription;

template<>
void Out<TSubscription>(IOutputStream& stream,
                        TTypeTraits<TSubscription>::TFuncParam subscription) {
    stream << subscription.GetHostName() << ";"
           << subscription.GetRequestKey() << ";"
           << subscription.GetSignalExpression();
}
