#pragma once

#include <infra/yasm/common/points/accumulators/accumulators.h>
#include <infra/yasm/common/labels/signal/signal_name.h>

#include <library/cpp/regex/pcre/regexp.h>

#include <util/generic/map.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>


namespace NZoom {
    namespace NYasmConf {

        class TParsingError: public yexception {
        };

        class TPatterns {
        private:
            TVector<std::pair<TRegExMatch, NZoom::NAccumulators::TAggregationRules>> Patterns;

        public:
            TPatterns(const TVector<std::pair<TRegExMatch, NZoom::NAccumulators::TAggregationRules>>& patterns);
            TPatterns(const TVector<std::pair<TRegExMatch, NZoom::NAccumulators::TAggregationRules>>&& patterns);

            const NZoom::NAccumulators::TAggregationRules* GetMatchedRule(const TString& signal) const;
            size_t GetSize() const noexcept;
            const TVector<std::pair<TRegExMatch, NZoom::NAccumulators::TAggregationRules>>& GetPatterns() const;
        };

        class TTypeConf : public TNonCopyable {
        public:
            using TSignalPair = std::pair<NZoom::NSignal::TSignalName, NZoom::NAccumulators::TAggregationRules>;
            using TSignalsMap = THashMap<NZoom::NSignal::TSignalName, NZoom::NAccumulators::TAggregationRules>;
        private:

            TAtomicSharedPtr<TSignalsMap> SignalsMap;
            TAtomicSharedPtr<TPatterns> Patterns;

            TAtomicSharedPtr<TSignalsMap> PeriodicSignalsMap;
            TAtomicSharedPtr<TPatterns> PeriodicPatterns;

        public:
            TTypeConf(
                TVector<TSignalPair>&& signals,
                TPatterns&& patterns,
                TVector<TSignalPair>&& periodicSignals,
                TPatterns&& periodicPatterns
            );

            TTypeConf(TTypeConf&& other);
            TTypeConf();

            const TAtomicSharedPtr<TSignalsMap> GetSignals() const;
            const TAtomicSharedPtr<TPatterns> GetPatterns() const;
            const TAtomicSharedPtr<TSignalsMap> GetPeriodicSignals() const;
            const TAtomicSharedPtr<TPatterns> GetPeriodicPatterns() const;
            const NZoom::NAccumulators::TAggregationRules* GetRules(const NZoom::NSignal::TSignalName& name) const;

        };

        class TYasmConf {
            TMap<TString, std::pair<TTypeConf, TTypeConf>> Types;
            TTypeConf CommonType;
            TTypeConf EmptyType;

        public:
            TYasmConf(TMap<TString, std::pair<TTypeConf, TTypeConf>>&& types, TTypeConf&& commonType);
            TYasmConf(TYasmConf&& other);

            TYasmConf& operator=(TYasmConf&& other);

            static TYasmConf FromString(TStringBuf str);
            static TYasmConf* FromCharString(TStringBuf str);
            static TYasmConf FromFileName(const TString& path);

            const TTypeConf& GetTypeConf(TStringBuf itype, const bool includeCommon) const;
        };
    }
}
