#include "yasmconf.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NZoom::NYasmConf;

Y_UNIT_TEST_SUITE(TZoomNYasmConfTest) {

    Y_UNIT_TEST(TestYasmConfParseProd) {
        const TString rawconf = TString() +
            "{ " +
            "\"conflist\": {" +
            "    \"addrsmeasure\": {" +
            "        \"patterns\": {}," +
            "        \"periods\": {}," +
            "        \"signals\": {}" +
            "     }," +
            "\"distributor\": {" +
            "    \"patterns\": {}," +
            "    \"periods\": {" +
            "        \"distributor_free_space-space-used-perc\": \"aver\"," +
            "        \"distributor_metrics-deposit\": \"summ\"," +
            "        \"distributor_metrics-requests\": \"summ\"" +
            "    }," +
            "    \"signals\": {" +
            "        \"distributor_free_space-space-used-perc\": [false, [\"aver\", true]]," +
            "        \"distributor_metrics-deposit\": [false, [\"summ\", true]]," +
            "        \"distributor_metrics-requests\": [false, [\"summ\", true]]" +
            "    }" +
            "}," +
            "\"common\": {" +
            "    \"patterns\": {" +
            "        \"iostat-max_load_(100|\\\\d\\\\d)\": [false, [\"summ\",true]]," +
            "        \"iostat-max_load_avg\": [false, [\"trnsp\", true]], " +
            "        \"iostat-max_load_max\": [false, [\"max\",true]]" +
            "    }," +
            "    \"periods\": {" +
            "        \"instances-discarded_instances\": \"summ\"," +
            "        \"instances-discarded_tags\": \"summ\"," +
            "        \"instances-ready_data_aggregated_size\": \"summ\"," +
            "        \"instances-ready_data_realtime_size\": \"summ\"," +
            "        \"instances-tags\": \"summ\"" +
            "    }," +
            "    \"signals\": {" +
            "        \"instances-discarded_instances\": [false, [\"summ\", true]]," +
            "        \"instances-discarded_tags\": [false, [\"summ\", true]]," +
            "        \"instances-ready_data_aggregated_size\": [false, [\"summ\", true]]," +
            "        \"instances-ready_data_realtime_size\": [false, [\"summ\", true]]," +
            "        \"instances-tags\": [false, [\"summ\", true]]" +
            "    }" +
            "  }" +
            " }" +
            "}";
        TYasmConf conf = TYasmConf::FromString(rawconf);

        {
            const TTypeConf& empty1 = conf.GetTypeConf("addrsmeasure", false);
            UNIT_ASSERT_VALUES_EQUAL(empty1.GetSignals()->size(), 0);
            UNIT_ASSERT_VALUES_EQUAL(empty1.GetPatterns()->GetSize(), 0);
            UNIT_ASSERT_VALUES_EQUAL(empty1.GetPeriodicSignals()->size(), 0);
            UNIT_ASSERT_VALUES_EQUAL(empty1.GetPeriodicPatterns()->GetSize(), 0);
        }

        {
            const TTypeConf& empty2 = conf.GetTypeConf("zzz", false);
            UNIT_ASSERT_VALUES_EQUAL(empty2.GetSignals()->size(), 0);
            UNIT_ASSERT_VALUES_EQUAL(empty2.GetPatterns()->GetSize(), 0);
            UNIT_ASSERT_VALUES_EQUAL(empty2.GetPeriodicSignals()->size(), 0);
            UNIT_ASSERT_VALUES_EQUAL(empty2.GetPeriodicPatterns()->GetSize(), 0);
        }

        {
            const TTypeConf& notEmpty = conf.GetTypeConf("distributor", false);
            UNIT_ASSERT_VALUES_EQUAL(notEmpty .GetSignals()->size(), 3);
            UNIT_ASSERT_VALUES_EQUAL(notEmpty .GetPatterns()->GetSize(), 0);
            UNIT_ASSERT_VALUES_EQUAL(notEmpty .GetPeriodicSignals()->size(), 3);
            UNIT_ASSERT_VALUES_EQUAL(notEmpty .GetPeriodicPatterns()->GetSize(), 0);
        }

        {
            const TTypeConf& emptyCommon1 = conf.GetTypeConf("addrsmeasure", true);
            UNIT_ASSERT_VALUES_EQUAL(emptyCommon1.GetSignals()->size(), 5);
            UNIT_ASSERT_VALUES_EQUAL(emptyCommon1.GetPatterns()->GetSize(), 3);
            UNIT_ASSERT_VALUES_EQUAL(emptyCommon1.GetPeriodicSignals()->size(), 5);
            UNIT_ASSERT_VALUES_EQUAL(emptyCommon1.GetPeriodicPatterns()->GetSize(), 0);
        }

        {
            const TTypeConf& emptyCommon2 = conf.GetTypeConf("zzz", true);
            UNIT_ASSERT_VALUES_EQUAL(emptyCommon2.GetSignals()->size(), 5);
            UNIT_ASSERT_VALUES_EQUAL(emptyCommon2.GetPatterns()->GetSize(), 3);
            UNIT_ASSERT_VALUES_EQUAL(emptyCommon2.GetPeriodicSignals()->size(), 5);
            UNIT_ASSERT_VALUES_EQUAL(emptyCommon2.GetPeriodicPatterns()->GetSize(), 0);
        }

        {
            const TTypeConf& notEmptyCommon = conf.GetTypeConf("distributor", true);
            UNIT_ASSERT_VALUES_EQUAL(notEmptyCommon.GetSignals()->size(), 8);
            UNIT_ASSERT_VALUES_EQUAL(notEmptyCommon.GetPatterns()->GetSize(), 3);
            UNIT_ASSERT_VALUES_EQUAL(notEmptyCommon.GetPeriodicSignals()->size(), 8);
            UNIT_ASSERT_VALUES_EQUAL(notEmptyCommon.GetPeriodicPatterns()->GetSize(), 0);
        }

        {
            const TTypeConf& explicitCommon = conf.GetTypeConf("common", false);
            UNIT_ASSERT_VALUES_EQUAL(explicitCommon.GetSignals()->size(), 5);
            UNIT_ASSERT_VALUES_EQUAL(explicitCommon.GetPatterns()->GetSize(), 3);
            UNIT_ASSERT_VALUES_EQUAL(explicitCommon.GetPeriodicSignals()->size(), 5);
            UNIT_ASSERT_VALUES_EQUAL(explicitCommon.GetPeriodicPatterns()->GetSize(), 0);
        }

    }

}
