from cpython cimport PyObject
from libcpp.utility cimport pair
from libcpp cimport bool as bool_t

from util.generic.string cimport TStringBuf, TString
from util.generic.vector cimport TVector
from util.generic.maybe cimport TMaybe
from util.system.types cimport i64, ui64

from infra.yasm.zoom.components.record.record cimport TRecord


cdef extern from "infra/yasm/histdb/components/streams/snappy.h" namespace "NHistDb" nogil:
    cdef enum ESnappyMode:
        READ "NHistDb::ESnappyMode::READ"
        APPEND "NHistDb::ESnappyMode::APPEND"


cdef extern from "infra/yasm/histdb/python/wrappers/something.h" namespace "NHistDb" nogil:
    cdef cppclass TSimpleSomethingRow:
        ui64 Timestamp
        ui64 RequestedIndex

        TRecord* ReleaseRecord()

    cdef cppclass TSimpleSomethingIteratorRow:
        ui64 Timestamp

        const TString& GetKey()
        TRecord* ReleaseRecord()

    cdef cppclass TSimpleSomethingKeyIteratorRow:
        const TString& GetKey()
        TVector[TString] GetSignals()

    cdef cppclass TSimpleSomethingIterator:
        TMaybe[TSimpleSomethingIteratorRow]& Next() except +

    cdef cppclass TSimpleSomethingKeyIterator:
        TMaybe[TSimpleSomethingKeyIteratorRow]& Next() except +

    cdef cppclass TReadData:
        ui64 TimeStamp
        TRecord* ReleaseRecord()
        TString RequesterName
        TString InstanceName

    cdef cppclass TSimpleSomethingFormat:
        TSimpleSomethingFormat(
            const TString& fileName, ESnappyMode mode, bool_t useDirect
        ) except +
        TSimpleSomethingFormat(
            TStringBuf incoming, const TString& fileName, ESnappyMode mode, bool_t useNewTags, bool_t useDirect
        ) except +

        TString Dump() except +

        void WriteRecord(ui64 timestamp, const TString& key, const TRecord& record) except +

        TVector[bool_t] HasRecords(
            const TVector[ui64]& timestamps,
            const TVector[TString]& keys
        ) except +

        TVector[TSimpleSomethingRow] ReadRecords(
            const TVector[ui64]& timestamps,
            const TVector[pair[TString, TVector[TString]]]& keysAndSignals
        ) except +

        TSimpleSomethingIterator IterateRecords(const TVector[ui64]& timestamps)
        TSimpleSomethingKeyIterator IterateKeys()

        TMaybe[ui64] FirstRecordTime() except +
        TMaybe[ui64] LastRecordTime() except +

        void Finish() except +

        TVector[TReadData] Read(const TVector[ui64]& times, const TVector[pair[TString, TVector[TString]]]& tags) except +
