#pragma once

#include <library/cpp/pybind/ptr.h>

#include <util/generic/string.h>
#include <util/generic/xrange.h>

namespace NZoom::NPython {
    inline TString ObjectToString(PyObject* object) {
        NPyBind::TPyObjectPtr convertedObjectPtr;

        if (PyUnicode_Check(object)) {
            PyObject* asciiString = PyUnicode_AsASCIIString(object);
            if (!asciiString) {
                PyErr_Clear();
                return TString();
            }
            convertedObjectPtr.Reset(NPyBind::TPyObjectPtr(asciiString, true));
            object = convertedObjectPtr.Get();
        }

        char* buf;
        Py_ssize_t len;
        if (!PyString_Check(object) || PyString_AsStringAndSize(object, &buf, &len)) {
            return TString();
        }
        return TString(buf, len);
    }

    template<typename F>
    inline bool IteratePyDict(PyObject* dict, F callback) {
        if (!PyDict_Check(dict)) {
            return false;
        }

        PyObject* itemKey;
        PyObject* itemValue;
        Py_ssize_t pos = 0;
        while (PyDict_Next(dict, &pos, &itemKey, &itemValue)) {
            callback(ObjectToString(itemKey), itemValue);
        }

        return true;
    }

    template <class F>
    inline bool IteratePyList(PyObject* root, F callback) {
        if (!PyList_Check(root)) {
            return false;
        }

        for (const auto position : xrange(PyList_Size(root))) {
            callback(PyList_GET_ITEM(root, position));
        }

        return true;
    }
}
