#pragma once

#include "subscriptions.h"
#include "message_pusher.h"
#include "tsdb.h"

#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/zoom/components/aggregators/subscription_filter.h>
#include <infra/yasm/zoom/components/aggregators/group.h>
#include <infra/yasm/zoom/components/aggregators/metrics.h>

#include <library/cpp/http/client/client.h>

#include <util/generic/queue.h>

#include <contrib/libs/msgpack/include/msgpack.hpp>

namespace NZoom {
    namespace NPython {
        class TMiddlePipeline {
        public:
            TMiddlePipeline(const NZoom::NYasmConf::TYasmConf& conf, IMessagePusher& tsdbPusher,
                            const TString& groupName, TInstant timestamp);

            void Mul(const NZoom::NRecord::TTaggedRecord& taggedRecord,
                     NZoom::NAggregators::TTaggedMetricManager& metricManager);

            void SetSubscriptions(const NZoom::NSubscription::TTagSignals& subscriptions);
            void SetSubscriptions(PyObject* value);

            void Finish();

            void Clean();
            void Clean(const TInstant explicitNow); // Debugging hook

            TStringBuf GetServerMessage() const;

            void SendTSDBMessages();

        private:
            const NZoom::NHost::THostName GroupName;
            const TInstant Timestamp;
            IMessagePusher& TsdbPusher;

            NZoom::NAggregators::TGroupAggregator GroupAggregator;

            TMaybe<TTsdbRequestState> TsdbRequestState;
            msgpack::sbuffer ServerMessage;

            NZoom::NAggregators::TSubscriptionFilter Subscriptions;

            bool Finished = false;

            void PrepareMessages();
        };
    }
}
