from libcpp cimport bool as bool_t
from libcpp.utility cimport pair

from cpython cimport PyObject

from util.system.types cimport ui64, ui16
from util.generic.hash cimport THashMap
from util.generic.string cimport TStringBuf, TString
from util.generic.vector cimport TVector
from util.datetime.base cimport TInstant, TDuration

from infra.yasm.zoom.components.aggregators.metrics cimport TTaggedMetricManager
from infra.yasm.zoom.components.record.record cimport TTaggedRecord
from infra.yasm.zoom.components.subscription.subscription cimport TSubscription
from infra.yasm.zoom.components.yasmconf.yasmconf cimport TYasmConf


cdef extern from "infra/yasm/zoom/python/pipelines/message_pusher.h" namespace "NZoom::NPython" nogil:
    cdef cppclass IMessagePusher:
        pass

    cdef cppclass TMessagePusher(IMessagePusher):
        TMessagePusher(TStringBuf url) except +

    cdef cppclass TAsyncMessagePusher(IMessagePusher):
        TAsyncMessagePusher(TStringBuf url, TDuration period) except +
        ui64 QueueSize() except +
        ui64 AllocatedInBack() except +

    cdef cppclass TInMemoryMessagePusher(IMessagePusher):
        TInMemoryMessagePusher() except +
        TVector[TString] GetMessages() except +
        void Clear() except +


cdef extern from "infra/yasm/zoom/python/pipelines/requester.h" namespace "NZoom::NPython" nogil:
    cdef cppclass TRequesterPipelineStatsAndMessages:
        THashMap[TString, TString] DeserializeErrors
        THashMap[TString, TString] AggregateErrors
        TVector[TString] InvalidResponseHosts
        TVector[TString] SerializeErrors
        long IgnoredSignals
        long NonProtoResponses
        long HostsSuccess

    cdef cppclass TRequesterPipeline:
        void SetSubscriptions(PyObject* value) except +
        void SetTime(TInstant timestamp) except +
        void SetMetricManager(TTaggedMetricManager& metricManager) except +

        void AddHostResponse(TStringBuf host, const TString& response, const TString& responseContentType) except +

        void Finish(TRequesterPipelineStatsAndMessages* statsAndMessages) except +
        void Clean() except +

        TVector[TStringBuf] GetMiddleMessages() except +
        TStringBuf GetServerMessage() except +


cdef extern from "infra/yasm/zoom/python/pipelines/middle.h" namespace "NZoom::NPython" nogil:
    cdef cppclass TMiddlePipeline:
        void Mul(const TTaggedRecord& taggedRecord, TTaggedMetricManager& metricManager) except +

        void SetSubscriptions(PyObject* value) except +
        void SetTime(TInstant timestamp) except +

        void Finish() except +
        void Clean() except +

        TStringBuf GetServerMessage() except +
        void SendTSDBMessages() except +


cdef extern from "infra/yasm/zoom/python/pipelines/server.h" namespace "NZoom::NPython" nogil:
    cdef cppclass TServerStats:
        size_t MaxKeySetPower
        size_t KeySetPowerSum
        size_t MaxResolvedKeySetPower
        size_t ResolvedKeySetPowerSum

    cdef cppclass TServerPipeline:
        void Mul(const TString& hostName, const TTaggedRecord& taggedRecord) except +

        void SetSubscriptions(PyObject* value) except +

        TServerStats Finish() except +
        void Clean() except +

        TString GetRequestedPointsMessage(TInstant iterationTs) except +


cdef extern from "infra/yasm/zoom/python/pipelines/server_worker.h" namespace "NZoom::NPython" nogil:
    cdef cppclass TServerWorker:
        TServerWorker(TString aggrName, size_t workersCount, ui16 subscriptionsPort, size_t threads) except +

        void Process(TInstant iterationTime, TString worker, TString data) except +
        TVector[TDuration] RealtimeDelays() except +


cdef extern from "infra/yasm/zoom/python/pipelines/subscriptions.h" namespace "NZoom::NPython" nogil:
    cdef cppclass TSubscriptionStoreProtobufRequestSerializer:
        @staticmethod
        TString SubscriptionsDictToListRequest(PyObject* subscriptionsDict) except +


cdef extern from "infra/yasm/zoom/components/aggregators/history.h" namespace "NZoom::NAggregators" nogil:
    cdef cppclass IHistoryAggregatorVisitor:
        pass


cdef extern from "infra/yasm/zoom/components/serialization/history/history.h" namespace "NZoom::NProtobuf" nogil:
    cdef cppclass THistoryRequest:
        const TString& GetHostName() except +

    cdef cppclass THistoryResponse:
        pass


cdef extern from "infra/yasm/zoom/python/pipelines/history.h" namespace "NZoom::NPython" nogil:
    cdef cppclass THistoryApiRequestSerializer:
        @staticmethod
        TString RequestsToProto(PyObject* requests, TInstant deadline, const TString& requestId) except +

        @staticmethod
        TString ResponsesToProto(const TVector[THistoryResponse*]& responses) except +

    cdef cppclass THistoryApiRequestDeserializer:
        THistoryApiRequestDeserializer() except +

        void Load(TStringBuf content) except +
        THistoryRequest* Next() except +
        bool_t IsEnd() except +

    cdef cppclass THistoryApiResponseDeserializer:
        THistoryApiResponseDeserializer() except +

        TVector[int] Load(TStringBuf content) except +
        void Merge() except +
        THistoryResponse* Next() except +
        bool_t IsEnd() except +

        @staticmethod
        THistoryResponse* FromPython(PyObject* response) except +

    cdef cppclass THistoryAggregatorWrapper:
        THistoryAggregatorWrapper(const TYasmConf& conf) except +

        void AddRequests(PyObject* requests) except +
        void AddMetagroups(PyObject* metagroups) except +

        void Mul(const THistoryResponse& response) except +
        void Overwrite(const THistoryAggregatorWrapper& other) except +
        void OverwriteSince(const THistoryAggregatorWrapper& other, TInstant since, TInstant until) except +
        void OverwriteContinuous(const THistoryAggregatorWrapper& other) except +
        void Visit(IHistoryAggregatorVisitor& visitor) except +

    cdef cppclass THistoryAggregatorToPythonVisitor(IHistoryAggregatorVisitor):
        void SetAllowLegacyTypes(bool_t allowLegacyTypes)
        PyObject* GetConvertedSmallSignals()
        PyObject* GetResponses()
