#include "serializers.h"
#include <infra/yasm/common/points/hgram/ugram/compress/compress.h>

namespace NZoom {
    namespace NPython {
        using namespace NMonitoring;

        void PackServerMessage(msgpack::packer<msgpack::sbuffer>& packer, const NZoom::NHost::THostName& hostName, const TTaggedFoundSignals& found) {
            packer.pack_array(2);
            PackString(packer, hostName.GetName());
            packer.pack_map(found.size());
            TSignalValueSerializer<NHgram::TUgramCompressor> serializer(packer);
            for (const auto& tagSignals : found) {
                PackString(packer, tagSignals.first.ToNamed());
                serializer.VisitFoundSignals(tagSignals.second);
            }
        }
    }
}
