#pragma once

#include "subscriptions.h"

#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/zoom/components/containers/storage.h>
#include <infra/yasm/zoom/components/yasmconf/yasmconf.h>
#include <infra/yasm/zoom/components/aggregators/subscription_filter.h>

#include <util/datetime/base.h>
#include <contrib/libs/msgpack/include/msgpack.hpp>

namespace NZoom {
    namespace NPython {
        struct TServerStats {
            size_t MaxKeySetPower = 0;
            size_t KeySetPowerSum = 0;
            size_t MaxResolvedKeySetPower = 0;
            size_t ResolvedKeySetPowerSum = 0;
        };

        struct TRequestKeyGroup {
            NZoom::NSubscription::TInternedRequestKey RequestKey;
            THashSet<NTags::TInstanceKey> ResolvedTags;
            NZoom::NAccumulators::TAccumulator Accumulator;

            explicit TRequestKeyGroup(const NZoom::NSubscription::TInternedRequestKey& requestKey,
                                      NZoom::NAccumulators::EAccumulatorType accumulatorType);
        };

        struct TTagGroup {
            TVector<NTags::TInstanceKey> Tags;
            TVector<NZoom::NValue::TValue> Values;
            TVector<TRequestKeyGroup> RequestKeyGroups;

            void Clear();
        };

        class TServerPipeline {
        public:
            explicit TServerPipeline(const TString& aggrName);

            void Mul(const TString& hostName, const NZoom::NRecord::TTaggedRecord& taggedRecord);
            void Mul(NZoom::NHost::THostName hostName, const NZoom::NRecord::TTaggedRecord& taggedRecord);

            void SetSubscriptions(const TVector<NZoom::NSubscription::TSubscription>& subscriptions);
            void SetSubscriptions(PyObject* value);

            TServerStats Finish();
            void Clean();

            TString GetRequestedPointsMessage(TInstant iterationTs) const;
        private:
            using TTagValue = std::pair<NZoom::NSignal::TSignalName, NZoom::NValue::TValue>;

            void WriteGroup(NZoom::NHost::THostName hostName, NZoom::NSignal::TSignalName signal, TTagGroup& tagGroup);

            const TString AggrName;

            THashMap<NZoom::NHost::THostName, THashMap<NZoom::NSignal::TSignalName, TTagGroup>> Points;
            THashMap<NZoom::NHost::THostName, THashMap<TString, TVector<TTagValue>>> RequestedPoints;

            bool Finished = false;
        };
    }
}
