#pragma once

#include <util/generic/string.h>
#include <util/datetime/base.h>

namespace NZoom {
    namespace NPython {
        /**
         * Native implementation of main part of worker_server.py from yasmcore.
         */
        class TServerWorker {
        public:
            /**
             * Instantiate server worker.
             *
             * Please note that this constructor starts several threads, so it is better to use
             * object of this class as long lived during whole process live.
             *
             * @param aggrName            unique name of aggregator (e.g. "SAS.059")
             * @param workersCount        number of workers (middles + requesters)
             * @param subscriptionsPort   port of locally running subscription store
             * @param threads             how many threads to start
             */
            TServerWorker(TString aggrName, size_t workersCount, ui16 subscriptionsPort, size_t threads);
            ~TServerWorker();

            /**
             * Process data form requester or middle.
             *
             * The given data will be processed in asynchronous manner, so method will not
             * block or wait anything to complete.
             *
             * @param iterationTime    worker iteration time
             * @param worker           name of the worker
             * @param data             serialized with msgpack data
             */
            void Process(TInstant iterationTime, TString worker, TString data);

            TVector<TDuration> RealtimeDelays();

        private:
            class TImpl;
            THolder<TImpl> Impl;
        };
    }
}
