#pragma once

#include <infra/yasm/common/labels/signal/signal_name.h>
#include <infra/yasm/zoom/components/subscription/subscription.h>
#include <infra/yasm/common/labels/tags/request_key.h>
#include <infra/yasm/common/labels/tags/dynamic_filter.h>

#include <Python.h>

namespace NZoom {
    namespace NPython {
        TVector<NSubscription::TSubscription> DeserializeSubscriptions(PyObject* subscriptions);
        TVector<NSubscription::TSubscription> DeserializeSubscriptions(TStringBuf msgPack);

        class TSubscriptionStoreProtobufRequestSerializer {
        public:
            /* Builds a subscription-store subscriptions list request for subscriptions packed in dictionary with the following
             * structure: {host : {tags : {signals}}}
             * NOTE: all tags (request keys) are implicitly normalized in request
             * */
            static TString SubscriptionsDictToListRequest(PyObject* subscriptionsDict);
        };
    }
}
