#include "tsdb.h"

using namespace NZoom::NPython;
using namespace NZoom::NProtobuf;

void TTsdbRequestState::FillRequest() const noexcept {
    size_t seriesCount = 0;
    for (const auto& hostRecord : Request->GetHostRecords()) {
        for (const auto& tagRecord : hostRecord.GetTagRecords()) {
            seriesCount += tagRecord.GetRecord().GetValues().size();
        }
    }
    Request->SetSeriesCount(seriesCount);
}

const NYasm::NInterfaces::NInternal::TTsdbPushSignalRequest& TTsdbRequestState::GetRequest() const noexcept {
    return *Request;
}

TString TTsdbRequestState::Serialize() const noexcept {
    FillRequest();
    return GetRequest().SerializeAsString();
}

TTsdbRequestPacker TTsdbRequestState::CreatePacker(TInstant timestamp, NZoom::NHost::THostName host, NZoom::NHost::THostName group) {
    auto* hostRecord(Request->MutableHostRecords()->Add());
    hostRecord->SetTimestamp(timestamp.Seconds());
    hostRecord->SetIsGroup(false);
    HostNameSerializer.Intern(host, hostRecord->MutableHost());
    HostNameSerializer.Intern(group, hostRecord->MutableGroup());
    return TTsdbRequestPacker(*hostRecord, InstanceKeySerializer, SignalNameSerializer);
}

TTsdbRequestPacker TTsdbRequestState::CreatePacker(TInstant timestamp, NZoom::NHost::THostName group) {
    auto* hostRecord(Request->MutableHostRecords()->Add());
    hostRecord->SetTimestamp(timestamp.Seconds());
    hostRecord->SetIsGroup(true);
    HostNameSerializer.Intern(group, hostRecord->MutableGroup());
    return TTsdbRequestPacker(*hostRecord, InstanceKeySerializer, SignalNameSerializer);
}

void TTsdbRequestPacker::SetCount(const size_t count) {
    HostRecord.MutableTagRecords()->Reserve(count);
}

void TTsdbRequestPacker::AddRecord(NTags::TInstanceKey key, const NZoom::NRecord::TRecord& record) {
    auto recordSerializer = CreateRecordSerializer(key);
    record.Process(recordSerializer);
}

void TTsdbRequestPacker::AddContainer(NTags::TInstanceKey key, const NZoom::NContainers::TGroupContainer& container) {
    auto recordSerializer = CreateRecordSerializer(key);
    container.Process(recordSerializer);
}

TProtobufRecordSerializer<NZoom::NHgram::TUgramCompressor> TTsdbRequestPacker::CreateRecordSerializer(NTags::TInstanceKey key) {
    auto* tagRecord = HostRecord.MutableTagRecords()->Add();
    InstanceKeySerializer.Intern(key, tagRecord->MutableInstanceKey());
    return TProtobufRecordSerializer<NZoom::NHgram::TUgramCompressor>(*tagRecord->MutableRecord(), SignalNameSerializer);
}
