#pragma once

#include <infra/yasm/common/labels/tags/instance_key.h>
#include <infra/yasm/common/labels/host/host.h>
#include <infra/yasm/common/points/hgram/ugram/compress/compress.h>
#include <infra/yasm/zoom/components/containers/group.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/host_name.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/instance_key.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/signal_name.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_protobuf/record.h>
#include <infra/yasm/interfaces/internal/tsdb.pb.h>

#include <util/datetime/base.h>

namespace NZoom {
    namespace NPython {
        class TTsdbRequestPacker;

        class TTsdbRequestState {
        public:
            TTsdbRequestState()
                : Request(google::protobuf::Arena::CreateMessage<NYasm::NInterfaces::NInternal::TTsdbPushSignalRequest>(&Arena))
                , HostNameSerializer(Request->MutableHostNameTable())
                , InstanceKeySerializer(Request->MutableInstanceKeyTable())
                , SignalNameSerializer(Request->MutableSignalNameTable())
            {
            }

            void FillRequest() const noexcept;
            const NYasm::NInterfaces::NInternal::TTsdbPushSignalRequest& GetRequest() const noexcept;
            TString Serialize() const noexcept;

            TTsdbRequestPacker CreatePacker(TInstant timestamp, NZoom::NHost::THostName host, NZoom::NHost::THostName group);
            TTsdbRequestPacker CreatePacker(TInstant timestamp, NZoom::NHost::THostName group);

        private:
            google::protobuf::Arena Arena;
            NYasm::NInterfaces::NInternal::TTsdbPushSignalRequest* Request;
            NZoom::NProtobuf::THostNameSerializer HostNameSerializer;
            NZoom::NProtobuf::TInstanceKeySerializer InstanceKeySerializer;
            NZoom::NProtobuf::TSignalNameSerializer SignalNameSerializer;
        };

        class TTsdbRequestPacker {
        public:
            TTsdbRequestPacker(NYasm::NInterfaces::NInternal::TTsdbHostRecord& hostRecord,
                               NZoom::NProtobuf::TInstanceKeySerializer& instanceKeySerializer,
                               NZoom::NProtobuf::TSignalNameSerializer& signalNameSerializer)
                : HostRecord(hostRecord)
                , InstanceKeySerializer(instanceKeySerializer)
                , SignalNameSerializer(signalNameSerializer)
            {
            }

            void SetCount(const size_t count);

            void AddRecord(NTags::TInstanceKey key, const NZoom::NRecord::TRecord& record);
            void AddContainer(NTags::TInstanceKey key, const NZoom::NContainers::TGroupContainer& container);

        private:
            NZoom::NProtobuf::TProtobufRecordSerializer<NZoom::NHgram::TUgramCompressor> CreateRecordSerializer(
                NTags::TInstanceKey key);

            NYasm::NInterfaces::NInternal::TTsdbHostRecord& HostRecord;
            NZoom::NProtobuf::TInstanceKeySerializer& InstanceKeySerializer;
            NZoom::NProtobuf::TSignalNameSerializer& SignalNameSerializer;
        };
    }
}
