from libcpp cimport bool as bool_t
from libcpp.utility cimport pair

from util.system.types cimport ui64

from util.generic.maybe cimport TMaybe
from util.generic.string cimport TStringBuf, TString
from util.generic.vector cimport TVector
from util.generic.hash cimport THashMap

from infra.yasm.zoom.components.value_types cimport TValue
from infra.yasm.zoom.components.record.record cimport TContinuousRecord, TTaggedRecordPtr, TSingleMultiTaggedRecord
from infra.yasm.zoom.components.subscription.subscription cimport TSubscriptionWithValueSeries


cdef extern from "infra/yasm/zoom/python/responses.h" namespace "NZoom::NPython" nogil:
    cdef cppclass TPerInstanceRecordsIterator:
        TSingleMultiTaggedRecord* ExtractRecord() except +
        TString GetInstanceName() except +
        void MoveNext()
        bool_t IsEnd()

    cdef cppclass TAgentProtobufResponseParser:
        TAgentProtobufResponseParser(TStringBuf valueStr) except +
        TMaybe[TString] GetStatus() except +
        pair[TTaggedRecordPtr, size_t] TaggedRecord() except +
        TPerInstanceRecordsIterator LoadPerInstanceRecords() except +

    cdef cppclass TInstanceContent:
        TStringBuf Key
        TContinuousRecord* Record

    cdef cppclass TMiddleResponseLoader:
        TMiddleResponseLoader() except +
        TTaggedRecordPtr LoadTaggedRecord(TStringBuf strResponse) except +

    cdef cppclass TServerResponseLoader:
        TServerResponseLoader() except +
        TVector[pair[TString, TTaggedRecordPtr]] LoadHostRecords(TStringBuf strResponse) except +

    cdef cppclass TSubscriptionSplitter:
        TSubscriptionSplitter(ui64 bucketCount) except +
        ui64 GetBucketCount();
        void SetMetagroupForGroup(const TStringBuf& groupName, const TStringBuf& metagroupName) except +
        ui64 GetSubscriptionBucket(const TStringBuf& host, const TStringBuf& tags) except +

    cdef cppclass THostSubscriptionsIterator:
        THostSubscriptionsIterator()
        bool_t IsEnd()
        void MoveNext()

        const TString& GetHostName() except +
        TVector[TSubscriptionWithValueSeries]* ExtractValues() except +

    cdef cppclass TGetSubscriptionValuesResponseLoader:
        TGetSubscriptionValuesResponseLoader() except +

        @staticmethod
        TVector[TString] Split(const TStringBuf& response, const TSubscriptionSplitter& splitter, ui64& maxStartTime) except +

        void Load(const TStringBuf& protobufGetValuesResponse) except +
        void Clear() except +

        THostSubscriptionsIterator GetHostSubscriptionsIterator()

    ctypedef struct TNodeAgentUnistatEndpoint:
        int Port
        TString Path
        TString Prefix
        THashMap[TString, TString] Labels
        TString ContainerFqdn

    ctypedef struct TNodeAgentSubagentEndpoint:
        int Port
        TString ContainerFqdn

    ctypedef struct TNodeAgentPodInfo:
        TString ContainerId
        TString Prefix
        THashMap[TString, TString] Labels
        TString ContainerFqdn

    ctypedef struct TNodeAgentWorkloadInfo:
        TString ContainerId
        TString Prefix
        THashMap[TString, TString] Labels
        TString ContainerFqdn

    ctypedef struct TNodeAgentContainerInfo:
        TString ContainerId
        THashMap[TString, TString] Labels
        TString ContainerFqdn

    cdef cppclass TNodeAgentResponseLoader:
        void Load(TStringBuf valueStr) except +
        TVector[TNodeAgentUnistatEndpoint] ExtractUnistatEndpoints() except +
        TVector[TNodeAgentSubagentEndpoint] ExtractSubagentEndpoints() except +
        TVector[TNodeAgentPodInfo] ExtractPodsInfo() except +
        TVector[TNodeAgentWorkloadInfo] ExtractWorkloadsInfo() except +
        TVector[TNodeAgentContainerInfo] ExtractSystemContainersInfo() except +
