#pragma once

#include <infra/yasm/zoom/components/record/record.h>
#include <infra/yasm/common/labels/signal/signal_name.h>
#include <infra/yasm/common/points/value/types.h>

#include <util/generic/hash.h>
#include <util/generic/maybe.h>

namespace NZoom {

    namespace NPython {

        enum class EDeserializationStatus : ui8 {
            OK,
            INVALID_UNSPECIFIED,
            NONE,
            UNKNOWN,
            EXTRA_DEPTH,
            TOO_MUCH_ARGUMENTS_IN_BUCKET
        };

        struct TUnistatStats {
            i64 FilteredSignals = 0;
            double LimitUsage = 0.0;
            i64 NumHgrams = 0;
            i64 NumSignals = 0;
            size_t NumUgramsChangedBuckets = 0;
            size_t ResponseBytes = 0;
            size_t InvalidSignals = 0;
            size_t ParseErrors = 0;
            EDeserializationStatus Status = EDeserializationStatus::UNKNOWN;
            NHgram::TUgramBuckets UgramSizes = InitializeUgramBucketCountUgram();

            NZoom::NValue::TValue* GetAndResetUgramSizes();
            void AddUgramBucketBorderCount(size_t borderCount);
            static NHgram::TUgramBuckets InitializeUgramBucketCountUgram();
        };

        struct TUnistatDiffValue {
            NZoom::NValue::TValue Abs;
            TMaybe<NZoom::NValue::TValue> DiffValue;
        };

        using TUnistatSignalTags = TString;
        using TUnistatDiffCounters = THashMap<NZoom::NSignal::TSignalName, TUnistatDiffValue>;
        using TUnistatTaggedDiffValues = THashMap<TUnistatSignalTags, TUnistatDiffCounters>;
        using TUnistatTagsMap = THashMap<TString, THashMap<NZoom::NSignal::TSignalName, NZoom::NValue::TValue>>;

        using TUnistatUgramBucketBorders = THashMap<NZoom::NSignal::TSignalName, TVector<double>>;
        using TUnistatTaggedUgramBuckets = THashMap<TUnistatSignalTags, TUnistatUgramBucketBorders>;

        struct TUnistatState {
            TUnistatTaggedDiffValues TaggedDiffValues;
            TUnistatTaggedUgramBuckets TaggedPrevUgramBuckets;
        };

        using TUnistatTaggedSignals = THashMap<TUnistatSignalTags, NZoom::NRecord::TRecord>;

        class TUnistatValuesIterator {
        private:
            using TSeries = TVector<std::pair<NZoom::NSignal::TSignalName, NZoom::NValue::TValue>>;
            TUnistatTagsMap Data;
            TUnistatStats Stats;
            TUnistatTagsMap::iterator Position;
        public:
           TUnistatValuesIterator();
           TUnistatValuesIterator(TUnistatTagsMap&& data, const TUnistatStats& stats);
           bool IsValid() const noexcept;
           //It's client responsibility to delete() record
           std::pair<TString, NZoom::NRecord::TRecord*> GetAndMove();
           const TUnistatStats& GetStats() const noexcept;
        };

        class TUnistatDeserializer {
        private:
            TString Prefix;
            size_t Limit;
            TMaybe<TUnistatState> PrevState;
        public:
            TUnistatDeserializer(const TStringBuf prefix, const size_t limit);
            TUnistatValuesIterator Loads(const TStringBuf jsonStr);
            void Loads(const TStringBuf jsonStr, TUnistatValuesIterator& it);
        };
    }
}
