from libcpp cimport bool as bool_t
from libcpp.utility cimport pair

from cpython cimport PyObject

from util.generic.string cimport TStringBuf, TString
from util.system.types cimport i64

from infra.yasm.zoom.components.record.record cimport TRecord
from infra.yasm.zoom.components.value_types cimport TValue

cdef extern from "infra/yasm/zoom/python/unistat/unistat.h" namespace "NZoom::NPython::EDeserializationStatus" nogil:
    cdef enum EDeserializationStatus "NZoom::NPython::EDeserializationStatus":
        OK
        INVALID_UNSPECIFIED
        NONE
        UNKNOWN
        EXTRA_DEPTH
        TOO_MUCH_ARGUMENTS_IN_BUCKET

cdef extern from "infra/yasm/zoom/python/unistat/unistat.h" namespace "NZoom::NPython" nogil:
    cdef cppclass TUnistatStats:
        i64 FilteredSignals
        double LimitUsage
        i64 NumHgrams
        i64 NumSignals
        size_t NumUgramsChangedBuckets
        size_t ResponseBytes
        size_t InvalidSignals
        size_t ParseErrors
        EDeserializationStatus Status
        TValue* GetAndResetUgramSizes() except +

    cdef cppclass TUnistatValuesIterator:
        bool_t IsValid() const
        pair[TString, TRecord*] GetAndMove()
        const TUnistatStats& GetStats()

    cdef cppclass TUnistatDeserializer:
        TUnistatDeserializer(const TStringBuf prefix, const size_t limit)
        void Loads(const TStringBuf jsonStr, TUnistatValuesIterator& it) except +
