from __future__ import unicode_literals

import six

import argparse

import requests
import os

requests.packages.urllib3.disable_warnings()


if __name__ == '__main__':
    parser = argparse.ArgumentParser('')
    parser.add_argument('--nanny_services')
    parser.add_argument('--gencfg_groups')
    args = parser.parse_args()

    nanny_session = requests.Session()
    nanny_session.headers['Authorization'] = 'OAuth {}'.format(os.environ["NANNY_TOKEN"])

    yp_session = requests.Session()
    yp_session.headers['Authorization'] = 'OAuth {}'.format(os.environ["YP_TOKEN"])

    accounts_total_per_dc = estimate_account(
        args.nanny_services.split(","), args.gencfg_groups.split(","),
        nanny_session, yp_session
    )

    account_total = Account.empty()
    for dc, account in six.iteritems(accounts_total_per_dc):
        account_total.add(account)

    print(account_total)
