from .utils import sort_by_date, is_folder_with_date, find_newest_backup
import itertools

def test_sort():
    subfolders = ["my_12345", "my_12346", "my_2223"]
    assert sorted(subfolders, cmp=sort_by_date ) == ["my_2223","my_12345","my_12346"]


def test_is_folder_with_date():
    assert is_folder_with_date("abc") == False
    assert is_folder_with_date("abc_123") == False
    assert is_folder_with_date("ypbackup_123") == True


def test_sort_cluster_by_date():
    clusters = {
        "arnold": "my_1234",
        "banach": "my_100",
        "hahn": "my_2000"
    }
    assert find_newest_backup(clusters) == ("hahn", "my_2000")


def test_del():
    test_dict = {"1": 1, "2":2, "3": 3}

    del test_dict["2"]
    assert test_dict == {"1": 1, "3": 3}

