def extract_date(text):
    splitted_text = text.split("_")
    return splitted_text[1]


def sort_by_date(left, right):
    return int(extract_date(left)) - int(extract_date(right))


def intTryParse(value):
    try:
        return int(value), True
    except ValueError:
        return value, False


def is_yp_backup_folder(name):
    splitted_name = name.split("_")
    if len(splitted_name) < 2 or splitted_name[0] != "ypbackup":
        return False

    date = splitted_name[1]
    value, result = intTryParse(date)
    return result


def find_newest_backup(clusters):
    return sorted(clusters.items(), key=lambda x: extract_date(x[1]), reverse=True)[0]
