from __future__ import print_function

import time
import sys


def retry_me(closure, retry_count, sleep_time=1.0, silent=False):
    retries = retry_count

    while retries > 0:
        try:
            retries = retries - 1
            return closure()
        except Exception as err:
            if not silent:
                print(err)
            if retries > 0:
                if not silent:
                    sys.stderr.write("Retrying, attempt {}\n".format(retry_count - retries))
                time.sleep(sleep_time)
            else:
                raise
