# coding=utf-8
import requests
from requests.packages.urllib3.util.retry import Retry
import requests.adapters


def create_session(oauth=None):
    session = requests.Session()
    session.verify = False

    retry = Retry(
        backoff_factor=0.3,
        total=10
    )
    session.mount(
        'http://',
        requests.adapters.HTTPAdapter(max_retries=retry),
    )
    session.mount(
        'https://',
        requests.adapters.HTTPAdapter(max_retries=retry),
    )
    if oauth is not None:
        session.headers['Authorization'] = 'OAuth {}'.format(oauth)

    return session
