from .module import find_expected_notification_level, round_to_day
from datetime import datetime


def test_notification_level_1():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", datetime(2018, 10, 1), (None, 0), datetime(2018, 10, 10), None)

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 1 and border_time == datetime(2018, 10, 8)


def test_notification_level_2():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", datetime(2018, 10, 1), (datetime(2018, 10, 10), 1), datetime(2018, 10, 18), None)

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 2 and border_time == datetime(2018, 10, 17)


def test_notification_level_3():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", datetime(2018, 10, 1), (datetime(2018, 10, 18), 2), datetime(2018, 10, 25), None)

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 3 and border_time == datetime(2018, 10, 25)


def test_notification_level_4():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", datetime(2018, 10, 1), (datetime(2018, 10, 25), 3), datetime(2018, 11, 2), None)

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 4 and border_time == datetime(2018, 11, 1)


def test_notification_level_5():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", datetime(2018, 10, 1), (datetime(2018, 11, 2), 4), datetime(2018, 11, 5), None)

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 5 and border_time == datetime(2018, 11, 2)


def test_notification_level_datetime_round():
    assert round_to_day(datetime(2018, 10, 23, 22, 23, 41)) == datetime(2018, 10, 23)

