from .module import find_expected_notification_level
from datetime import datetime


def test_notification_level_1():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", datetime(2018, 10, 1), (None, 0), datetime(2018, 10, 10), datetime(2018, 10, 30))

    print "expected_notification_level={} border_time={} proposed_deadline={}".format(expected_notification_level, border_time, proposed_deadline)
    assert expected_notification_level == 1 and border_time == datetime(2018, 10, 8) and proposed_deadline == datetime(2018, 11, 1)


def test_notification_level_2():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1",
                                         pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 10), 1),
                                         current=datetime(2018, 10, 18),
                                         deadline=datetime(2018, 10, 30))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 2 and border_time == datetime(2018, 10, 17) and proposed_deadline == datetime(2018, 11, 2)


def test_notification_level_2_1():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 10), 1),
                                         current=datetime(2018, 10, 18),
                                         deadline=datetime(2018, 11, 30))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 1 and border_time == datetime(2018, 10, 1) and proposed_deadline == datetime(2018, 11, 30)


def test_notification_level_2_2():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 10), 1),
                                         current=datetime(2018, 10, 18),
                                         deadline=datetime(2018, 11, 04))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 1 and border_time == datetime(2018, 10, 13) and proposed_deadline == datetime(2018, 11, 04)


def test_notification_level_2_21():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 14), 1),
                                         current=datetime(2018, 10, 18),
                                         deadline=datetime(2018, 11, 04))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 1 and border_time == datetime(2018, 10, 14) and proposed_deadline == datetime(2018, 11, 05)


def test_notification_level_2_22():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 14), 1),
                                         current=datetime(2018, 10, 22),
                                         deadline=datetime(2018, 11, 04))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 2 and border_time == datetime(2018, 10, 21) and proposed_deadline == datetime(2018, 11, 06)


def test_notification_level_2_3():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 8), 1),
                                         current=datetime(2018, 10, 8),
                                         deadline=datetime(2018, 11, 04))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 1 and border_time == datetime(2018, 10, 1) and proposed_deadline == datetime(2018, 11, 04)


def test_notification_level_2_4():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 8), 1),
                                         current=datetime(2018, 10, 8),
                                         deadline=datetime(2018, 11, 8))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 1 and border_time == datetime(2018, 10, 1) and proposed_deadline == datetime(2018, 11, 8)


def test_notification_level_3():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1",
                                         pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 8), 1),
                                         current=datetime(2018, 10, 9),
                                         deadline=datetime(2018, 11, 8))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 1 and border_time == datetime(2018, 10, 1) and proposed_deadline == datetime(2018, 11, 8)


def test_notification_level_3_1():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1",
                                         pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 15), 2),
                                         current=datetime(2018, 10, 16),
                                         deadline=datetime(2018, 11, 20))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 1 and border_time == datetime(2018, 10, 1) and proposed_deadline == datetime(2018, 11, 20)


def test_notification_level_4():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", datetime(2018,10,1), (datetime(2018, 10, 25), 3), datetime(2018, 11, 2), None)

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 4 and border_time == datetime(2018, 11, 2)


def test_notification_level_5():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("1", datetime(2018, 10, 1), (datetime(2018, 11, 2), 4), datetime(2018, 11, 5), None)

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 5 and border_time == datetime(2018, 11, 3)


def test_notification_level_6():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("edadeal - redis - sh5 - n2",
                                         pod_creation_time=datetime(2018, 8, 27),
                                         notification_tuple=(datetime(2018, 10, 04), 3),
                                         current=datetime(2018, 10, 16),
                                         deadline=datetime(2018, 11, 01))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 2 and border_time == datetime(2018, 10, 10) and proposed_deadline == datetime(2018, 11, 01)


def test_notification_level_7():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("rtc-salt-dashboard",
                                         pod_creation_time=datetime(2018, 10, 1),
                                         notification_tuple=(datetime(2018, 10, 16, 0, 59, 41), 2),
                                         current=datetime(2018, 10, 16, 1, 00, 47),
                                         deadline=datetime(2018, 10, 31))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 2 and border_time == datetime(2018, 10, 16) and proposed_deadline == datetime(2018, 10, 31)


def test_notification_level_8():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("reddi-first-service",
                                         pod_creation_time=datetime(2018, 10, 3),
                                         notification_tuple=(datetime(2018, 10, 23, 22, 23, 41), 2),
                                         current=datetime(2018, 10, 23, 23, 13, 50),
                                         deadline=datetime(2018, 11, 7))

    print "expected_notification_level={} border_time={}".format(expected_notification_level, border_time)
    assert expected_notification_level == 2 and border_time == datetime(2018, 10, 23) and proposed_deadline == datetime(2018, 11, 7)


def test_notification_level_9():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("reddi-first-service",
                                         pod_creation_time=datetime(2018, 10, 3),
                                         notification_tuple=(datetime(2018, 10, 23, 22, 23, 41), 2),
                                         current=datetime(2018, 10, 23, 23, 13, 50),
                                         deadline=datetime(2018, 11, 7))

    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("reddi-first-service",
                                         pod_creation_time=datetime(2018, 10, 3),
                                         notification_tuple=(datetime(2018, 10, 23, 22, 23, 41), 2),
                                         current=datetime(2018, 10, 23, 23, 13, 51),
                                         deadline=proposed_deadline)

    assert expected_notification_level == 2


def test_notification_level_10():
    expected_notification_level, proposed_deadline, border_time = \
        find_expected_notification_level("reddi-first-service",
                                         pod_creation_time=datetime(2018, 10, 3),
                                         notification_tuple=(datetime(2018, 10, 16), 1),
                                         current=datetime(2018, 10, 24, 12, 19, 50),
                                         deadline=datetime(2018, 11, 7))

    assert expected_notification_level == 2 and proposed_deadline == datetime(2018, 11, 8)

    print "second stage"
    expected_notification_level2, proposed_deadline2, border_time2 = \
        find_expected_notification_level("reddi-first-service",
                                         pod_creation_time=datetime(2018, 10, 3),
                                         notification_tuple=(datetime(2018, 10, 24, 12, 19, 12), 2),
                                         current=datetime(2018, 10, 25, 8, 43, 42),
                                         deadline=datetime(2018, 11, 7))

    assert expected_notification_level2 == 2 and proposed_deadline2 == datetime(2018, 11, 8)

