#include <infra/yp_dns/libs/config/printer/printer.h>
#include <infra/yp_dns/libs/daemon/main.h>
#include <infra/yp_dns/libs/view_log/view_log.h>

#include <infra/libs/logger/log_printer.h>

#include <library/cpp/getopt/small/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char** argv) {
    TModChooser modChooser;

    modChooser.AddMode("run",
                       NYP::DNS::RunDaemon,
                       "Run yp_dns daemon.");

    modChooser.AddMode("print_log",
                       NInfra::PrintEventLog,
                       "Print yp_dns eventlog.");

    modChooser.AddMode("view_log",
                       NInfra::NViewLog::ViewLog,
                       "Print sorted log or selected fields.");

    modChooser.AddMode("print_config",
                       NYP::DNS::PrintConfig,
                       "Print yp_dns config.");

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
