# Основные разделы

**YP DNS** - инсталляция авторитетных DNS серверов на основе [PowerDNS](https://doc.powerdns.com/authoritative/), обслуживающая запросы зон внутреннего облака (yp-c.yandex.net, gencfg-c.yandex.net, qloud-\*.yandex.net, etc); также **YP DNS** является собирательным понятием совокупности технологий, соединяющих системы DNS и [YP](https://wiki.yandex-team.ru/yp/).

## Основные разделы документации

### [DNS-зоны в YP DNS](zones/index.md)

В разделе дается описание зон в системе YP DNS, рассказывается о типах зон, как они используются и для чего служат.

### [API для управления данными DNS в YP](yp_dns_api/api.md)

В разделе описывается API сервиса YP DNS API Bridge, призванного служить мостиком между клиентом, желающим поменять DNS записи в системе, и кластерами YP, непосредственно хранящими эти данные.

### [Применение и репликация изменений DNS записей](yp_dns_api/replication.md)

В разделе описывается алгоритм применения изменений ресурсных записей в YP, запрошенных пользователем через [API](yp_dns_api/api.md).
Также подробно описывается способ репликации изменений между кластерами YP.

### [Unbound over YP](unbound/index.md)

Unbound - open source DNS-сервер, используемый в Яндексе на множестве инсталляций (рекурсивные, авторитетные).

### [PowerDNS over YP (aka YP DNS)](yp_dns/index.md)

PowerDNS - другой open source авторитетный DNS-сервер.
Используется в Яндексе для обслуживания RTC зон: yp-c.yandex.net, gencfg-c.yandex.net и некоторых других.

### [YP Реплика](replica/index.md)

Реплика - это ключевая технология для связи DNS с YP, она поддерживает локальную копию данных из YP и предоставляет доступ к ним на чтение.
Она используется во многих программах системы: Unbound, YP DNS, YP DNS API (Bridge) и др.
В разделе описаны основные принципы работы, а также важные особенности и фичи.

### [Генерация файлов зон](misc/zonefiles_generation.md)

Файл зоны ([Zone file](https://en.wikipedia.org/wiki/Zone_file)) - классический вариант представления DNS зоны, который представляет из себя текстовый файл со списком всех записей.
Такие файлы генерируются в том числе для зон, которые хранятся в кластерах YP.
На странице приведена релевантная информация к этому процессу.

### [Документация для дежурного](duty/index.md)

Полезная информация для дежурных YP DNS.
