# Полокационные обновления Реплик

Здесь находится описание работы системы.
Подробности по эксплуатации [тут](https://wiki.yandex-team.ru/ypdns/polokacionnye-apdejjty-dns/jekspluatacija).

## Задача

Координировать работу нескольких YP Реплик в разных локациях. В частности данные должны приезжать в локации по определенной последовательности с задержкой.

Например, данные кластера YP-SAS поступают в кластер SAS без задержки, в MAN с задержкой 5с относительно SAS, во VLA еще через 5с после MAN.

## Решение

Между Репликами и YP появляется специальный сервис **YP Updates Coordinator**, координирующий работу Реплик через выдачу YP-таймстемпов по запросам к нему. См. схему

![Схема](https://jing.yandex-team.ru/files/dima-zakharov/ypupdatescoordinatorscheme.png)

### YP Реплика

Каждая YP Реплика создает ноду `//<root path>/<service>/instances/<instance fqdn>` в Кипарисе и захватывает лок на ней в том же YT-кластере, с которым работает нужный YP-кластер.
Имя создаваемой ноды – fqdn инстанса, на котором работает Реплика.
В атрибутах ноды инстанс записывает метаинформацию о себе (например, название локации инстанса).
По завершении работы Реплика отпускает лок и удаляет созданную ноду.

Также на каждом цикле синхронизации Реплики с мастером YP Реплика пишет свой стейт в общие с другими инстансами YP Реплик динтаблицы.
Эти динтаблицы находятся по пути: `//<root path>/<service>/meta`.
В таблице `versions` пишется информация о таймстемпе.
В таблице `state` хранится текущий статус каждого инстанса – YP-таймстемп используемых данных (`current_timestamp`), YP-таймстемп следующих данных (`target_timestamp`), последний YP-таймстемп, отправленный координатором инстансу (`sent_timestamp`).

Для получения YP-таймстемпа на очередном цикле синхронизации YP Реплика запрашивает его у координатора через метод `GetTargetState`.

### YP Updates Coordinator

Координатор обслуживает запросы `GetTargetState` от YP Реплик. Запросы над каждым YP-кластером Координатор обслуживает независимо.

Координатор реплицирован, стейт хранит в YT.

#### Алгоритм определения целевого (target) таймстемпа

Сначала Координатор получает список всех работающих инстансов через операцию `list` на директорию `//<root path>/<service>/instances` и проверку захваченных локов.
Дальше запрашивает информацию о таймстемпах из динтаблиц `state` и `versions` для этих инстансов.

Координатор определяет целевой таймстемп для локации инстанса из запроса. Далее

* если все инстансы локации достигли этого таймстемпа (`current == target`), то для локации выбирается следующий таймстемп (об этом ниже), этот таймстемп отдается в ответе на текущий запрос
* иначе инстансу отдается текущий целевой таймстемп для локации

Целевой таймстемп локации поддерживается Координатором в `uint64`-ноде по пути `//<root path>/<service>/coordinator/locations/<location>/target`.
Рядом в динтаблице `versions` хранится история таймстемпов локации.
Следующий YP-таймстемп локации определяется по следующим правилам:

* Если это первая локация по порядку, то следующий таймстемп генерируется запросом `generate_timestamp` в YP.
* Иначе выбирается YP-таймстемп предыдущей по порядку локации, который был использован ей N секунд назад. Для этого выполняется select-запрос на динтаблицу `versions` той локации:

  ```sql
  * from [/<root path>/<service>/coordinator/locations/<prev location>/versions]
  where update_time <= (now() - delay).mcs()
  order by update_time desc
  limit 1
  ```

  Затем в `target` обновляется целевой таймстемп.

## Особенные кейсы и их решения

### Старт Реплики блокирует обновления остальных Реплик в локации

**Проблема.** Когда Реплика только поднимается и делает это долго (например, качает обновления через full select), то это блокирует обновление целевого таймстемпа для этой локации и, соответственно, последующих.

**Решение.** Для клиента Координатора вводятся роли: *leader* и *follower*.
В роли leader инстанс участвует в координации: его стейт влияет на стейт локации в целом и, соответственно, на алгоритм выбора таймстемпа для локации.
В роли follower же инстанс просто следует за остальными инстансами в локации, для него Координатор всегда отдает просто целевой таймстемп локации, а его стейт никак не учитывается.

Когда Реплика стартует и еще не поднялась, то она использует клиент к Координатору в роли follower.
А как только данные скачались и Реплика готова обслуживать запросы, клиент переходит в роль leader.

Тикет: [YP-3075](https://st.yandex-team.ru/YP-3075).

### Recovery после штатной недоступности YP

**Проблема.** После долгого даунтайма кластера YP реплики могу зависнуть на таймстемпе, который не могут использовать, потому что он протух (время жизни YP таймстемпов ограничено).
По оригинальному алгоритму новый таймстемп в таком случае не перевыбирается, поскольку не все инстансы перешли на целевой таймстемп.

**Решение.** Вводится механизм timestamp reelection.
Заключается он в том, чтобы форсировать перевыбор таймстемпа для локации, когда текущий целевой таймстемп по объективным причинам невалиден.

Инстансы теперь дополнительно при ошибке запроса в YP пишут в динамическую таблицу `meta/versions` усон с описанием ошибки (колонка `update_status`) и количество попыток обновиться на таймстемп (колонка `update_attempts`).

Координатор действует [следующим образом](https://a.yandex-team.ru/arc/trunk/arcadia/infra/libs/yp_updates_coordinator/coordinator/location_coordinator.cpp?rev=r9002620#L240):

1. когда инстанс запрашивает target-таймстемп, Координатор смотрит на статус апдейта на этот таймстемп по всем инстансам
2. (*явный сигнал*) если хотя бы у одного при апдейте на этот таймстемп была ошибка с определенными кодами (пока только [TimestampOutOfRange](https://a.yandex-team.ru/arc/trunk/arcadia/infra/libs/yp_updates_coordinator/coordinator/location_coordinator.cpp?rev=r9002620#L255)), то таймстемп для локации перевыбирается
3. (*неявный сигнал*) или если хотя бы один инстанс пытался неуспешно обновиться на этот таймстемп (статус [`TUpdateStatus::YP_ERROR`](https://a.yandex-team.ru/arcadia/infra/libs/yp_updates_coordinator/instance_state/state/state.h?rev=r9002620#L17)) в течение более [`MinAllowedTimeToUpdateSinceReceiving`](https://a.yandex-team.ru/arcadia/infra/libs/yp_updates_coordinator/coordinator/protos/config/config.proto?rev=r9554173#L8-9) времени (дефолт: 1 минута) и количество попыток было более [`MinAllowedErrorAttemptsToUpdate`](https://a.yandex-team.ru/arcadia/infra/libs/yp_updates_coordinator/coordinator/protos/config/config.proto?rev=r9554173#L10-11) (дефолт: 3 попытки), то также для локации таймстемп перевыбирается.

Тикет: [YP-2802](https://st.yandex-team.ru/YP-2802).

## Ссылки

* Код библиотеки: [infra/libs/yp_updates_coordinator](https://a.yandex-team.ru/arcadia/infra/libs/yp_updates_coordinator)
* Директория сервиса для DNS: [infra/yp_dns_updates_coordinator](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_dns_updates_coordinator)
