# Интеграция Unbound с YP

Данные DNS в Яндексе хранятся в системе [YP](https://wiki.yandex-team.ru/yp).
Чтобы Unbound мог использовать эти данные, был дописан код, позволяющий скачивать данные из YP и использовать их для ответа.
Ниже подробно описывается эта интеграция Unbound с YP.

## Устройство данных DNS в YP

В YP для DNS хранятся ресурсные записи (resource records) и конфиги динамических зон. Ресурсные записи хранятся в объектах типа `dns_record_set` – это объединение записей по домену. Конфиги динамических зон в объектах типа `dns_zone`.

### Объекты dns_record_set

Protobuf-описание объекта: [yp_proto/data_model.proto](https://a.yandex-team.ru/arc_vcs/yp/yp_proto/yp/client/api/proto/data_model.proto?rev=r9443207#L2740).

В поле `/meta/id` объекта хранится домен записей. Список записей (значения `ttl`, `class`, `type`, `data`) хранится в поле `/spec/records`.
В `/labels` хранится информация о зоне, [список изменений](../yp_dns_api/replication.md) и другая мета-информация.

Объекты хранятся во всех кластерах YP. В каких именно - зависит от зоны, которой они принадлежат.

### Объекты dns_zone

Protobuf-описание объекта: [yp_proto/dns_zone.proto](https://a.yandex-team.ru/arc_vcs/yp/yp_proto/yp/client/api/proto/dns_zone.proto).

В поле `/meta/id` содержится имя зоны. Сам конфиг находится в `/spec`.

Объекты хранятся в кластере XDC, который в отличии от других кластеров мультидатацентровый by design, а следовательно имеет меньший downtime, но все же ненулевой.

## Скачивание и доступ к данным из YP: Реплика {#yp-replica}

Чтобы сервер мог быстро отвечать на запросы пользователей, данные должны лежать как можно ближе к памяти.
Для скачивания данных из YP и локального доступа к ним написана библиотека [infra/libs/yp_replica](https://a.yandex-team.ru/arc/trunk/arcadia/infra/libs/yp_replica).
Основная сущность библиотеки - [YP Replica](https://a.yandex-team.ru/arc/trunk/arcadia/infra/libs/yp_replica/yp_replica.h) (далее просто Реплика) - именно она качает и хранит данные, а также предоставляет интерфейс для доступа к данным.

Одна Реплика отвечает за работу только с одним YP кластером и одним типом объектов. То есть dns_record_set-ы, например, из кластеров SAS и VLA качаются разными Репликами. dns_zone-ы качаются также отдельной Репликой. Разные Реплики независимы друг от друга.

### Скачивание данных

Для получения данных из YP Реплика использует запросы [SelectObjects](https://wiki.yandex-team.ru/yp/api#metodselectobjects) или [WatchObjects + GetObjects](https://wiki.yandex-team.ru/yp/api#metodwatchobjects).
Запросами первого типа выкачиваются все данные из кластера полностью.
Однако это может быть долго, если, например, в кластере данных много.
Но обычно изменений происходит достаточно мало (относительно числа объектов),
поэтому после полного выкачивания данных дешевле следить только за обновлениями, произошедшими с момента последнего обновления.
Для этого используется связка [WatchObjects + GetObjects](https://wiki.yandex-team.ru/yp/api#metodwatchobjects).
Метод `WatchObjects` возвращает список `id` объектов, которые были изменены в заданном интервале времени,
дальше этот список передается в метод `GetObjects`, возвращающий контент этих объектов.

Результат скачивания данных сравнивается с тем, что уже присутствует в сторадже, и разница (diff) применяется к данным через операции Put или Delete.

### Хранение данных (сторадж)

Для хранения данных на диске используется библиотека [RocksDB](https://github.com/facebook/rocksdb) от компании Facebook (ныне Meta; огранизация признана экстримистской и запрещена в РФ).

Данные хранятся в виде key-value в табличках (column family).
В основной табличке, где хранятся объекты, ключом является `id` объекта (домен для `dns_record_set` и имя зоны для `dns_zone`, соответственно),
а значением - сам объект в сериализованном виде.

Данные хранятся на диске.

### Доступ к данным

Реплика поддерживает два типа метода для доступа к данным:

1. Получение объекта по ключу ([GetByKey](https://a.yandex-team.ru/arc/trunk/arcadia/infra/libs/yp_replica/yp_replica.h?rev=r9443234#L213)).
1. Листинг объектов ([ListElements](https://a.yandex-team.ru/arc/trunk/arcadia/infra/libs/yp_replica/yp_replica.h?rev=r9443234#L208)).
