# Изменение конфигурации в рантайме: ITS

## Какие инсталляции DNS подключены к ITS?

Пока только авторитеты ns1.yp-dns.yandex.net и ns2.yp-dns.yandex.net aka **YP DNS**.

На других инсталляциях ITS не подключен, но накладывать патчи можно локально, записав файл с патчем по пути указанному в [конфиге](https://a.yandex-team.ru/arcadia/infra/libs/updatable_proto_config/protos/config.proto?rev=r7958867#L8).

## Что можно менять?

Можно применить изменение практически к любому полю конфига.
Однако, **не любые** изменения будут фактически применены, т.к. некоторый код использует константные значения, полученные из конфига на старте (хотя при рестарте инстанса изменения все-таки будут применены).

## У кого есть права менять патчи в ITS?

Актуальный список всегда можно найти в [секции acl](https://nanny.yandex-team.ru/ui/#/its/config/edit/acl) маски **yp_dns/\*\***.
В основном там члены [ABC группы YP DNS](http://abc.yandex-team.ru/services/yp_dns/).

## Инструкции

Перед составлением патча в ITS **крайне рекомендуется** сначала ознакомиться с деталями того, как этот патч будет применен: [ссылка](https://wiki.yandex-team.ru/users/dima-zakharov/updatableprotoconfig/).

{% note tip %}

Протестируйте ваше изменение, перед применением.
Некорректный патч может сделать страшные и порой непоправимые вещи.

{% endnote %}

### Остановить апдейты данных из кластера YP

1. Выясняем имя нужного YP-кластера: `sas-test|man-pre|sas|man|vla|myt|iva|xdc`.
   Для примера пусть это `sas`.
2. Применяем патч

   ```json
   {
     "patch": {
       "YPClusterConfigs": {
         "sas": {
           "EnableUpdates": false
         }
       }
     }
   }
   ```

### Откатить данные на бэкап

1. Выясняем имя нужного YP-кластера: `sas-test|man-pre|sas|man|vla|myt|iva|xdc`.
   Для примера пусть это `sas`.
2. Определяемся со временем, когда данные еще были валидны.
   Переводим это время в миллисекунды.
3. Смотрим список доступных бэкапов: `curl sas1-0861-sas-yp-dns-15186.gencfg-c.yandex.net:9091/backup/sas/list/json | jq .`.
   Удостоверяемся по метке времени `Timestamp` (в секундах), что валидные бэкапы есть.
   (Не запутайтесь в таймзонах!).
4. Применяем патч (также останавливая апдейты):

   ```json
   {
     "patch": {
       "YPClusterConfigs": {
         "sas": {
           "RollbackToBackup": {
             "Rollback": true,
             "MaxAcceptableTimestamp": <timestamp в мс>
           },
           "EnableUpdates": false
         }
       }
     }
   }
   ```

   {% note warning %}

   После успешного отката бэкапы с более поздним timestamp-ом будут удалены, т.е. откат на них будет невозможен.

   {% endnote %}

### Добавить/удалить зону

Список зон находится в конфиге по пути `Zones` (это `repeated` поле).
Чтобы добавить или удалить зону, нужно в патче обновить весь список **целиком**.

- Текущий список зон можно посмотреть либо по ручке `curl sas1-0861-sas-yp-dns-15186.gencfg-c.yandex.net:9091/config | jq .Zones`, либо в [конфиге](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_dns/config/config.json).
- **Добавляя или удаляя зоны обязательно нужно указать зоны из текущего конфига.**

```json
{
  "patch": {
    "Zones": [
      <оригинальный список зон> + <добавленная зона>
    ]
  }
}
```

{% note tip %}

Протестируйте ваше изменение, перед применением.
Некорректный патч может сделать ужасные вещи, вплоть до того, что все зоны будут удалены.

{% endnote %}

### Отменить все наложенные через ITS изменения

Есть два способа это сделать:

1. Удалить патч в ITS, нажав на красную кнопочку с пиктограммой корзины.
2. Применить существующий патч, добавив `"dont_apply": true` в корневом объекте.
   Например,

   ```json
   {
     "dont_apply": true,
     "patch": {
       "YPClusterConfigs": {
         "sas": {
           "EnableUpdates": false
         }
       }
     }
   }
   ```
