# DNS-зоны в YP DNS

Как известно, доменные имена [представляют собой](https://en.wikipedia.org/wiki/Domain_Name_System#Structure) древовидную структуру,
где домен `.` является корнем и от него исходят ребра в домены первого уровня (`ru.`, `com.`, `net.` и др.),
из которых в свою очередь исходят ребра в домены в второго уровня (`yandex.ru.`, `google.com.`) и так далее.
**Зоной** называется любое поддерево в такой структуре.

В YP DNS для определенных целей каждый DNS record set (домен с набором его DNS-записей) неявным образом связан с какой-то DNS-зоной (максимум **одной**).
Это нужно, например, для того, чтобы [определить](../yp_dns_api/replication.md#find-zone) в каких YP-кластерах искать ответ для запрошенного домена.

## Статические и динамические зоны

Зоны в YP DNS подразделяются на два типа: статические и динамические.
Статические - это те, которые прописаны в конфигах сервисов явным образом.
Динамические же зоны могут управляться в рантайме (создаваться, меняться, удаляться), записи о них в конфиге не нужны: сервис автоматически в онлайне обновляет их список.

### [Динамические зоны](dynamic.md)

Про пользовательский API для управления динамическими зонами можно найти на [странице](../yp_dns_api/api.md#list-zones) с описанием API Бриджа.
Тут же пойдет речь о внутреннем устройстве работы с такими зонами: как они создаются, управляются, хранятся и тп.

### Статические зоны

Статические зоны отдельной страницы с описанием не требуют.
Чтобы их использовать (а лучше вообще не использовать) просто опишите конфигурацию зоны в конфиге вашего сервиса.
