#include "main.h"

#include <infra/yp_dns/libs/service/service.h>

#include <infra/libs/sensors/sensor_registry.h>

#include <infra/contrib/pdns/power_dns/dnsbackend.hh>
#include <infra/contrib/pdns/power_dns/receiver.hh>

#include <library/cpp/resource/registry.h>

namespace NYP::DNS {

int RunDaemon(int argc, const char* argv[]) {
    NInfra::SetSensorRegistryCommonGroup({"yp_dns"});
    BackendMakers().report(new TDnsFactory());
    RunPDNS(argc, const_cast<char**>(argv));
    return EXIT_SUCCESS;
}

int RunDaemon(TStringBuf config, int argc, const char** argv) {
    const TString compressedConfig = NResource::Compress(config);
    NResource::TRegHelper("/test_proto_config.json", compressedConfig);
    return RunDaemon(argc, argv);
}

} // namespace NYP::DNS
