#pragma once

#include <infra/yp_dns/libs/config/protos/config.pb.h>
#include <infra/yp_dns/libs/logger/events/events_decl.ev.pb.h>

#include <infra/libs/logger/logger.h>
#include <infra/libs/logger/self_closing_logger.h>

#include <infra/contrib/pdns/power_dns/dnsname.hh>
#include <infra/contrib/pdns/power_dns/dnspacket.hh>
#include <infra/contrib/pdns/power_dns/qtype.hh>

#include <util/generic/noncopyable.h>

namespace NYP::DNS {

class TBackendEventsLogger;
using TBackendEventsLoggerPtr = TIntrusivePtr<TBackendEventsLogger>;

class TBackendEventsLogger : public TThrRefBase {
public:
    static TBackendEventsLoggerPtr CreateBackendEventsLogger(NInfra::TLogger& logger) {
        return MakeIntrusive<TBackendEventsLogger>(TBackendEventsLogger(logger));
    }

    template <typename TStartEvent, typename TFinishEvent>
    NInfra::TFrameBioChapter CreateSubframe(
        TStartEvent&& startEvent,
        TFinishEvent&& finishEvent,
        TIntrusivePtr<NInfra::THistogramRateSensor> frameTimeHistogram = nullptr
    ) {
        return NInfra::CreateBioChapterForFrame(LogFrame_, std::move(startEvent), std::move(finishEvent), frameTimeHistogram);
    }

    void LogBackendRequestData(const QType& qtype, const DNSName& domain) const;
    void LogPacketInfo(DNSPacket* packet) const;
    void LogLookupResult(ui32 recordsNumber) const;
    void LogListCluster(const TString& cluster, ui64 timestamp) const;
    void LogListResult(const TString& zone, ui32 recordsNumber, bool success, const TString& message = {}) const;
    void LogListResult(const DNSName& zone, ui32 recordsNumber, bool success, const TString& message = {}) const;
    void LogUnallowedResourceType() const;
    void LogUnknownZone(const DNSName& domain) const;
    void LogZoneInfo(const NYpDns::TZoneConfig& zone) const;

private:
    TBackendEventsLogger(NInfra::TLogger& logger);

    NInfra::TLogFramePtr LogFrame_;
};

} // namespace NYP::DNS
