#include "router_api.h"

#include <infra/libs/service_iface/str_iface.h>

namespace NYP::DNS {
    NInfra::TRequestRouterPtr CreateRouter(IApi& service, const TConfig& config) {
        auto router = MakeSimpleShared<NInfra::TRequestRouter<IApi>>(service);

        (*router)
            .Add<NInfra::TEmptyRequest<NApi::TReqPing>, NInfra::TProto2JsonReply<NApi::TRspPing>>("/ping", "Ping", &IApi::Ping)
            .Add<NInfra::TEmptyRequest<NApi::TReqShutdown>, NInfra::TEmptyReply<NApi::TRspShutdown>>("/shutdown", "Shutdown", &IApi::Shutdown)
            .Add<NInfra::TEmptyRequest<NApi::TReqReopenLog>, NInfra::TProto2JsonReply<NApi::TRspReopenLog>>("/reopen_log", "Reopen log", &IApi::ReopenLog)
            .Add<NInfra::TEmptyRequest<NApi::TReqSensors>, NInfra::TRawDataReply<NApi::TRspSensors>>("/sensors", "Show sensors", &IApi::Sensors)
            .Add<NInfra::TEmptyRequest<NApi::TReqConfig>, NInfra::TRawDataReply<NApi::TRspConfig>>("/config", "Show config", &IApi::Config);

        for (const auto& cluster : config.GetYPClusterConfigs()) {
            (*router)
                .Add<NInfra::TEmptyRequest<NApi::TReqListBackups>, NInfra::TProto2JsonReply<NApi::TRspListBackups>>(
                    TString::Join("/backup/", cluster.GetName(), "/list/json"),
                    TString::Join("List backups for ", cluster.GetName(), " (json)"),
                    &IApi::ListBackups
                )
                .Add<NInfra::TEmptyRequest<NApi::TReqListBackups>, NInfra::TSerializedProtoReply<NApi::TRspListBackups>>(
                    TString::Join("/backup/", cluster.GetName(), "/list"),
                    TString::Join("List backups for ", cluster.GetName()),
                    &IApi::ListBackups
                )
                .Add<NInfra::TSerializedProtoRequest<NApi::TReqRollbackToBackup>, NInfra::TProto2JsonReply<NApi::TRspRollbackToBackup>>(
                    TString::Join("/rollback/", cluster.GetName(), "/backup"),
                    TString::Join("Rollback to backup for ", cluster.GetName(), " (json)"),
                    &IApi::RollbackToBackup
                )
                .Add<NInfra::TJson2ProtoRequest<NApi::TReqRollbackToBackup>, NInfra::TSerializedProtoReply<NApi::TRspRollbackToBackup>>(
                    TString::Join("/rollback/", cluster.GetName(), "/backup"),
                    TString::Join("Rollback to backup for ", cluster.GetName()),
                    &IApi::RollbackToBackup
                )
                .Add<NInfra::TEmptyRequest<NApi::TReqStartUpdates>, NInfra::TRawDataReply<NApi::TRspStartUpdates>>(
                    TString::Join("/updates/", cluster.GetName(), "/start"),
                    "Start updates",
                    &IApi::StartUpdates
                )
                .Add<NInfra::TEmptyRequest<NApi::TReqStopUpdates>, NInfra::TRawDataReply<NApi::TRspStopUpdates>>(
                    TString::Join("/updates/", cluster.GetName(), "/stop"),
                    "Stop updates",
                    &IApi::StopUpdates
                );
        }

        return router;
    }

}
