#include "view_log.h"

namespace NYP::DNS::NPrivate {

using namespace ::NInfra;

void TViewStatisticsRemoteAddress::ProcessEvent(const TEvent* event, TDataUnit& dataUnit) const {
    if (event->Id() != AllowedId_) {
        return;
    }

    dataUnit["RemoteHost"].push_back(NViewLog::GetEventFieldAsString(event, "RemoteHost"));
}

void TViewStatisticsRequestAddress::ProcessEvent(const TEvent* event, TDataUnit& dataUnit) const {
    if (event->Id() != AllowedId_) {
        return;
    }

    dataUnit["DestinationAddress"].push_back(NViewLog::GetEventFieldAsString(event, "DestinationAddress"));
}

TViewStatisticsEmptyResponse::TViewStatisticsEmptyResponse() {
    ui64 allowedId = IdByName("TLookupResult");

    EventProcessors_.push_back([allowedId](const TEvent* event, TDataUnit& dataUnit) {
        if (event->Id() != allowedId) {
            return;
        }

        if (NViewLog::GetEventFieldAsString(event, "RecordsNumber") == "0") {
            dataUnit["FrameMatched"].push_back("true");
        }
    });

    allowedId = IdByName("TPacketInfo");

    EventProcessors_.push_back([allowedId](const TEvent* event, TDataUnit& dataUnit) {
        if (event->Id() != allowedId) {
            return;
        }

        dataUnit["DestinationAddress"].push_back(NViewLog::GetEventFieldAsString(event, "DestinationAddress"));
    });
}

void TViewStatisticsEmptyResponse::ProcessEvent(const TEvent* event, TDataUnit& dataUnit) const {
    for (auto& processor : EventProcessors_) {
        processor(event, dataUnit);
    }
}

void TViewStatistics::PrintDataUnit(const TDataUnit& dataUnit) const {
    Cout << dataUnit.find("Output")->second.back();
}

void TViewStatistics::ProcessDataCore(TData& data, const TString& keyToFind) const {
    //TData is TVector< TMap<TString, std::any> >
    TVector<std::pair<int, size_t>> counters;
    TVector<TString> ids;
    THashMap<TString, size_t> idToIndex;

    auto getIndex = [&counters, &idToIndex, &ids](const TString& id) {
        auto itr = idToIndex.find(id);
        size_t ret;

        if (itr == idToIndex.end()) {
            ret = counters.size();
            idToIndex[id] = ret;
            counters.emplace_back(0, ret);
            ids.push_back(id);
        } else {
            ret = itr->second;
        }

        return ret;
    };

    for (auto& dataUnit : data) {
        auto it = dataUnit.find(keyToFind);

        Y_ENSURE(it != dataUnit.end());

        const TString id = it->second.back();
        size_t idx = getIndex(id);
        counters[idx].first++;
    }

    using TCounter = std::pair<int, size_t>;
    StableSort(counters.begin(), counters.end(), [](const TCounter& lhs, const TCounter& rhs) {
        return lhs.first > rhs.first;
    });

    data.clear();
    data.push_back(TDataUnit());
    TDataUnit& dataUnit = data[0];

    TStringStream stream;
    for (auto [cnt, idx] : counters) {
        stream << ids[idx] << "\t" <<  cnt << "\n";
    }
    dataUnit["Output"].push_back(stream.Str());
}

} // namespace NYP::DNS::NPrivate
