import json
import logging

import dns.name


class Quantity:
    def __init__(self, *args):
        if len(args) == 0:
            self.data = {}
        elif isinstance(args[0], str):
            try:
                printable_result = json.load(open(args[0], 'r'))
                result = {}
                for cluster, quantity in printable_result.items():
                    result[cluster] = {}
                    for zone, count in quantity.items():
                        result[cluster][dns.name.from_text(zone)] = count
                self.data = result
            except Exception as e:
                logging.warning("Failed to read json from file {}: {}".format(args[0], e))
                self.data = {}
        elif isinstance(args[0], dict):
            self.data = args[0]
        else:
            raise Exception("Could not create Quantity instance from the following parameters: [{}]".format(args))

    def write(self, path):
        printable_result = {}
        for cluster, quantity in self.data.items():
            printable_result[cluster] = {}
            for zone, count in quantity.items():
                printable_zone = str(zone)
                if printable_zone[-1] == '.':
                    printable_zone = printable_zone[:-1]
                printable_result[cluster][printable_zone] = count
        try:
            with open(path, 'w') as write_file:
                json.dump(printable_result, write_file, indent=4)
        except Exception as e:
            logging.warning("Failed to write json to file {}: {}".format(path, e))
