#include "apply_zone_snapshot.h"
#include "readers.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NYpDns;
using namespace NYpDns::NApplyZoneSnapshotToYp;

Y_UNIT_TEST_SUITE(AreRecordSetsEqual) {
    Y_UNIT_TEST(Equal) {
        TRecordSet firstRecordSet, secondRecordSet;
        {
            TStringBuilder zoneFile;
            zoneFile << "$ORIGIN    yandex.net.             \n";
            zoneFile << "$TTL       3600                    \n";
            zoneFile << "@      IN  AAAA    RecordData1     \n";
            zoneFile << "@      IN  A       RecordData1     \n";
            zoneFile << "@  600 IN  A       RecordData2     \n";
            zoneFile << "@      IN  CNAME   RecordData      \n";
            zoneFile << "@      IN  CNAME   RecordData      \n";
            zoneFile << "@      IN  AAAA    RecordData2     \n";
            zoneFile << "@      IN  AAAA    RecordData3     \n";
            zoneFile << "@      IN  AAAA    RecordData4     \n";
            TStringInput input(zoneFile);
            TZoneReader zoneReader(input);
            firstRecordSet = (GetRecordSetsFromZonefile(zoneReader))["yandex.net"];
        }
        {
            TStringBuilder zoneFile;
            zoneFile << "$ORIGIN    yandex.net.             \n";
            zoneFile << "@      IN  AAAA    RecordData4     \n";
            zoneFile << "@      IN  A       RecordData2     \n";
            zoneFile << "@  700 IN  A       RecordData1     \n";
            zoneFile << "@  500 IN  CNAME   RecordData      \n";
            zoneFile << "@      IN  AAAA    RecordData2     \n";
            zoneFile << "@      IN  AAAA    RecordData1     \n";
            zoneFile << "@  900 IN  CNAME   RecordData      \n";
            zoneFile << "@      IN  AAAA    RecordData3     \n";
            TStringInput input(zoneFile);
            TZoneReader zoneReader(input);
            secondRecordSet = (GetRecordSetsFromZonefile(zoneReader))["yandex.net"];
        }
        UNIT_ASSERT(AreRecordSetsEqual(firstRecordSet, secondRecordSet));
    }
    Y_UNIT_TEST(DifferentSize) {
        TRecordSet firstRecordSet, secondRecordSet;
        {
            TStringBuilder zoneFile;
            zoneFile << "yandex.net.  IN  AAAA  RecordData1 \n";
            zoneFile << "yandex.net.  IN  AAAA  RecordData2 \n";
            TStringInput input(zoneFile);
            TZoneReader zoneReader(input);
            firstRecordSet = (GetRecordSetsFromZonefile(zoneReader))["yandex.net"];
        }
        {
            TStringBuilder zoneFile;
            zoneFile << "yandex.net.  IN  AAAA  RecordData1 \n";
            TStringInput input(zoneFile);
            TZoneReader zoneReader(input);
            secondRecordSet = (GetRecordSetsFromZonefile(zoneReader))["yandex.net"];
        }
        UNIT_ASSERT(!AreRecordSetsEqual(firstRecordSet, secondRecordSet));
    }
    Y_UNIT_TEST(DifferentRecord) {
        {
            TRecordSet firstRecordSet, secondRecordSet;
            {
                TStringBuilder zoneFile;
                zoneFile << "yandex.net.  IN  AAAA  RecordData1 \n";
                zoneFile << "yandex.net.  IN  AAAA  RecordData2 \n";
                TStringInput input(zoneFile);
                TZoneReader zoneReader(input);
                firstRecordSet = (GetRecordSetsFromZonefile(zoneReader))["yandex.net"];
            }
            {
                TStringBuilder zoneFile;
                zoneFile << "yandex.net.  IN  AAAA  RecordData1 \n";
                zoneFile << "yandex.net.  IN  A     RecordData2 \n";
                TStringInput input(zoneFile);
                TZoneReader zoneReader(input);
                secondRecordSet = (GetRecordSetsFromZonefile(zoneReader))["yandex.net"];
            }
            UNIT_ASSERT(!AreRecordSetsEqual(firstRecordSet, secondRecordSet));
        }
        {
            TRecordSet firstRecordSet, secondRecordSet;
            {
                TStringBuilder zoneFile;
                zoneFile << "yandex.net.  IN  AAAA  RecordData1 \n";
                zoneFile << "yandex.net.  IN  AAAA  RecordData2 \n";
                TStringInput input(zoneFile);
                TZoneReader zoneReader(input);
                firstRecordSet = (GetRecordSetsFromZonefile(zoneReader))["yandex.net"];
            }
            {
                TStringBuilder zoneFile;
                zoneFile << "yandex.net.  IN  AAAA  RecordData1 \n";
                zoneFile << "yandex.net.  IN  AAAA  RecordData3 \n";
                TStringInput input(zoneFile);
                TZoneReader zoneReader(input);
                secondRecordSet = (GetRecordSetsFromZonefile(zoneReader))["yandex.net"];
            }
            UNIT_ASSERT(!AreRecordSetsEqual(firstRecordSet, secondRecordSet));
        }
    }
}
