#pragma once

#include "lazy_requests_applier.h"

#include <infra/libs/yp_dns/record_set/record_set.h>

#include <yp/cpp/yp/token.h>

namespace NYpDns::NApplyZoneSnapshotToYp {

bool AreRecordSetsEqual(const TRecordSet& firstRecordSet, const TRecordSet& secondRecordSet);

struct TApplyZoneSnapshotOptions {
    NYP::NClient::TTransactionFactory& Factory;
    const TLazyRequestsApplierOptions& ApplierOptions;
    const TString& NameZone;
    const bool ChangeNSAndSOA;

    TApplyZoneSnapshotOptions(NYP::NClient::TTransactionFactory& factory,
                              const TLazyRequestsApplierOptions& options,
                              const TString& name,
                              bool change = false)
        : Factory(factory)
        , ApplierOptions(options)
        , NameZone(name)
        , ChangeNSAndSOA(change)
    {
    }
};

void ApplyZoneSnapshot(const TMap<TString, TRecordSet>& recordSetsFromZonefile, 
                       const TMap<TString, TRecordSet>& recordSetsFromYp,
                       const TApplyZoneSnapshotOptions& options);

} // NYpDns::NApplyZoneSnapshotToYp
