#include "logging.h"

#include <library/cpp/protobuf/json/proto2json.h>

namespace NYpDns::NApplyZoneSnapshotToYp {

using namespace NProtobufJson;

void PrintLogSelectObject(const TRecordSet& recordSet) {
    INFO_LOG << "Record set was downloaded" << Endl
             << "Object id: " << recordSet.Meta().id() << Endl
             << "Record set: " << Proto2Json(recordSet.Spec(), TProto2JsonConfig().SetEnumMode(TProto2JsonConfig::EnumValueMode::EnumName)) << Endl;
}

void PrintLogCreateRequest(const TRecordSet& recordSet) {
    INFO_LOG << "Adding a creation request to the batch" << Endl
             << "Object id: " << recordSet.Meta().id() << Endl
             << "Record set: " << NProtobufJson::Proto2Json(recordSet.Spec(), TProto2JsonConfig().SetEnumMode(TProto2JsonConfig::EnumValueMode::EnumName)) << Endl;
}

void PrintLogUpdateRequest(const TString& objectId, const TRecordSet& before, const TRecordSet& after) {
    INFO_LOG << "Adding a update request to the batch" << Endl
             << "Object id: " << objectId << Endl
             << "Record set before: " << NProtobufJson::Proto2Json(before.Spec(), TProto2JsonConfig().SetEnumMode(TProto2JsonConfig::EnumValueMode::EnumName)) << Endl
             << "Record set after: " << NProtobufJson::Proto2Json(after.Spec(), TProto2JsonConfig().SetEnumMode(TProto2JsonConfig::EnumValueMode::EnumName)) << Endl;
}

void PrintLogRemoveRequest(const TString& objectId) {
    INFO_LOG << "Adding a remove request to the batch" << Endl
             << "Object id: " << objectId << Endl;
}

} // namespace NYpDns::NApplyZoneSnapshotToYp
