#include "processing_record_set.h"

namespace NYpDns::NApplyZoneSnapshotToYp {

TRecordSet MergeRecordSet(const TRecordSet& first, const TRecordSet& second) {
    if (first.Meta().id() != second.Meta().id()) {
        ythrow yexception() << "Merge recordset error: different ids";
    }
    TRecordSet result = first;
    result.MutableSpec()->mutable_records()->MergeFrom(second.Spec().records());
    return result;
}

std::pair<TRecordSet, TRecordSet> SplitRecordSet(const TRecordSet& recordSet, 
    const TVector<NYP::NClient::NApi::NProto::TDnsRecordSetSpec::TResourceRecord::EType>& types)
{
    std::pair<TRecordSet, TRecordSet> result;
    *result.first.MutableMeta() = recordSet.Meta();
    *result.second.MutableMeta() = recordSet.Meta();
    for (const auto& record : recordSet.Spec().records()) {
        if (!IsIn(types, record.type())) {
            *result.first.MutableSpec()->add_records() = record;
        } else {
            *result.second.MutableSpec()->add_records() = record;
        }
    }
    return result;
}

} // namespace NYpDns::NApplyZoneSnapshotToYp
