#include "readers.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NYpDns;
using namespace NYpDns::NApplyZoneSnapshotToYp;

Y_UNIT_TEST_SUITE(GetRecordSetsFromZonefile) {
    Y_UNIT_TEST(ValidateRandomSequence) {
        TStringBuilder zoneFile;
        zoneFile << "$ORIGIN yandex.net.                                          \n";
        zoneFile << "@              IN AAAA RecordSet#1 (cc); yandex.net.         \n";
        zoneFile << "               IN AAAA RecordSet#1 (aa); yandex.net.         \n";
        zoneFile << "xm             IN AAAA RecordSet#2 (1) ; xm.yandex.net       \n";
        zoneFile << "               IN AAAA RecordSet#2 (bb); xm.yandex.net       \n";
        zoneFile << "yandex.net.    IN AAAA RecordSet#1 (3) ; yandex.net.         \n";
        zoneFile << "               IN AAAA RecordSet#1 (dd); yandex.net.         \n";
        zoneFile << "xmm            IN AAAA RecordSet#3 (1) ; xmm.yandex.net.     \n";
        zoneFile << "@              IN AAAA RecordSet#1 (ee); yandex.net.         \n";
        zoneFile << "                                       ; nothing             \n";
        zoneFile << "                                       ; nothing             \n";
        zoneFile << "xmm            IN AAAA RecordSet#3 (tt); xmm.yandex.net.     \n";
        zoneFile << "xmm            IN AAAA RecordSet#3 (3) ; xmm.yandex.net.     \n";
        zoneFile << "xm             IN AAAA RecordSet#2 (3) ; xm.yandex.net.      \n";
        
        TStringInput input(zoneFile);
        TZoneReader zoneReader(input);

        TMap<TString, TRecordSet> result;
        UNIT_ASSERT_NO_EXCEPTION(result = GetRecordSetsFromZonefile(zoneReader));

        UNIT_ASSERT_EQUAL(result.size(), 3);
        UNIT_ASSERT(result.contains("yandex.net"));
        UNIT_ASSERT(result.contains("xm.yandex.net"));
        UNIT_ASSERT(result.contains("xmm.yandex.net"));

        UNIT_ASSERT_STRINGS_EQUAL(result["yandex.net"].Meta().id(), "yandex.net");
        UNIT_ASSERT_STRINGS_EQUAL(result["xm.yandex.net"].Meta().id(), "xm.yandex.net");
        UNIT_ASSERT_STRINGS_EQUAL(result["xmm.yandex.net"].Meta().id(), "xmm.yandex.net");

        UNIT_ASSERT_EQUAL(result["yandex.net"].Spec().records_size(), 5);
        UNIT_ASSERT_EQUAL(result["xm.yandex.net"].Spec().records_size(), 3);
        UNIT_ASSERT_EQUAL(result["xmm.yandex.net"].Spec().records_size(), 3);

        UNIT_ASSERT_STRINGS_EQUAL(result["yandex.net"].Spec().records(0).data(), "RecordSet#1 (cc)");
        UNIT_ASSERT_STRINGS_EQUAL(result["yandex.net"].Spec().records(1).data(), "RecordSet#1 (aa)");
        UNIT_ASSERT_STRINGS_EQUAL(result["yandex.net"].Spec().records(2).data(), "RecordSet#1 (3)");
        UNIT_ASSERT_STRINGS_EQUAL(result["yandex.net"].Spec().records(3).data(), "RecordSet#1 (dd)");
        UNIT_ASSERT_STRINGS_EQUAL(result["yandex.net"].Spec().records(4).data(), "RecordSet#1 (ee)");

        UNIT_ASSERT_STRINGS_EQUAL(result["xm.yandex.net"].Spec().records(0).data(), "RecordSet#2 (1)");
        UNIT_ASSERT_STRINGS_EQUAL(result["xm.yandex.net"].Spec().records(1).data(), "RecordSet#2 (bb)");
        UNIT_ASSERT_STRINGS_EQUAL(result["xm.yandex.net"].Spec().records(2).data(), "RecordSet#2 (3)");

        UNIT_ASSERT_STRINGS_EQUAL(result["xmm.yandex.net"].Spec().records(0).data(), "RecordSet#3 (1)");
        UNIT_ASSERT_STRINGS_EQUAL(result["xmm.yandex.net"].Spec().records(1).data(), "RecordSet#3 (tt)");
        UNIT_ASSERT_STRINGS_EQUAL(result["xmm.yandex.net"].Spec().records(2).data(), "RecordSet#3 (3)");
    }
}
