#pragma once

#include <infra/libs/yp_dns/record_set/record_set.h>

#include <yp/cpp/yp/client.h>
#include <yp/cpp/yp/fwd.h>

#include <library/cpp/threading/future/async.h>

#include <util/generic/ptr.h>
#include <util/system/mutex.h>
#include <util/thread/pool.h>

namespace NYpDns::NGenerateZoneFiles {

class TYpClusterData {
public:
    TYpClusterData(TString name, const NYP::NClient::TClientOptions& ypClientOptions, IThreadPool& pool);

    NThreading::TFuture<TVector<TSerializedRecordSet>> RecordSets();

private:
    TVector<TSerializedRecordSet> LoadRecordSets() const;

private:
    const TString Name_;
    NYP::NClient::TClientPtr YpClient_;
    IThreadPool& Pool_;

    TMutex RecordSetsMutex_;
    NThreading::TFuture<TVector<TSerializedRecordSet>> RecordSets_;
};

using TYpClusterDataRef = TAtomicSharedPtr<TYpClusterData>;

class TYpClusterDataFactory {
public:
    TYpClusterDataFactory(size_t threads = 8);

    TYpClusterDataRef GetYpClusterData(const TString& clusterName);

private:
    TMutex Mutex_;
    THolder<IThreadPool> ThreadPool_;
    THashMap<TString, TYpClusterDataRef> YpClusterDataHolders_;
};

TYpClusterDataRef GetYpClusterData(const TString& clusterName);

} // namespace NYpDns::NGenerateZoneFiles
